/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core;

import T145.metalchests.core.MetalChests;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;

class UpdateChecker {
    UpdateChecker() {
    }

    private static ForgeVersion.CheckResult getResult() {
        return ForgeVersion.getResult((ModContainer)FMLCommonHandler.instance().findContainerFor((Object)"metalchests"));
    }

    static boolean hasUpdate() {
        ForgeVersion.CheckResult result = UpdateChecker.getResult();
        if (result.status == ForgeVersion.Status.PENDING) {
            MetalChests.LOG.warn("Cannot check for updates! Found status PENDING!");
            return false;
        }
        return result.status.isAnimated();
    }

    private static String getLatestVersion() {
        return UpdateChecker.getResult().target.toString();
    }

    static ITextComponent getUpdateNotification() {
        ITextComponent prefix = new TextComponentTranslation("metalchests.client.update.prefix", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        ITextComponent base = new TextComponentTranslation("metalchests.client.update", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
        TextComponentString postfix = new TextComponentString(TextFormatting.AQUA + UpdateChecker.getLatestVersion() + TextFormatting.GOLD + "!");
        return prefix.func_150257_a(base).func_150257_a((ITextComponent)postfix);
    }
}

