/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core.modules;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.ItemsMC;
import T145.metalchests.api.chests.IInventoryHandler;
import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.chests.UpgradeRegistry;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ChestUpgrade;
import T145.metalchests.api.immutable.ModSupport;
import T145.metalchests.api.immutable.RegistryMC;
import T145.metalchests.blocks.BlockMetalChest;
import T145.metalchests.blocks.BlockSortingMetalChest;
import T145.metalchests.client.render.blocks.RenderMetalChest;
import T145.metalchests.core.ModLoader;
import T145.metalchests.items.ItemChestUpgrade;
import T145.metalchests.tiles.TileHungryMetalChest;
import T145.metalchests.tiles.TileSortingHungryMetalChest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;

class ModuleThaumcraft {
    ModuleThaumcraft() {
    }

    @Mod.EventBusSubscriber(modid="metalchests", value={Side.CLIENT})
    static class ClientLoader {
        ClientLoader() {
        }

        @Optional.Method(modid="thaumcraft")
        @SubscribeEvent
        public static void onModelRegistration(ModelRegistryEvent event) {
            if (ModSupport.hasThaumcraft()) {
                for (ChestType chestType : ChestType.values()) {
                    ModLoader.registerModel(BlocksMC.HUNGRY_METAL_CHEST, chestType.ordinal(), ModLoader.getVariantName(chestType));
                }
                ModLoader.registerTileRenderer(TileHungryMetalChest.class, new RenderMetalChest(){

                    @Override
                    protected ResourceLocation getActiveResource(ChestType type) {
                        return new ResourceLocation("metalchests", "textures/entity/chest/hungry/" + type.func_176610_l() + ".png");
                    }
                });
                for (Enum enum_ : ChestUpgrade.values()) {
                    ModLoader.registerModel(ItemsMC.HUNGRY_CHEST_UPGRADE, "item_hungry_chest_upgrade", enum_.ordinal(), "item=" + ((ChestUpgrade)enum_).func_176610_l());
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="metalchests")
    static class ServerLoader {
        ServerLoader() {
        }

        private static ItemStack tryToInsertStack(IItemHandler inv, @Nonnull ItemStack stack) {
            int slot;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                if (inv.getStackInSlot(slot).func_190926_b() || !(stack = inv.insertItem(slot, stack, false)).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                if (!(stack = inv.insertItem(slot, stack, false)).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        private static void tryToEatItem(World world, BlockPos pos, IBlockState state, Entity entity, Block receiver) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IInventoryHandler && entity instanceof EntityItem && !entity.field_70128_L) {
                IInventoryHandler chest = (IInventoryHandler)te;
                EntityItem item = (EntityItem)entity;
                ItemStack stack = item.func_92059_d();
                ItemStack leftovers = ServerLoader.tryToInsertStack(chest.getInventory(), stack);
                if (leftovers == null || leftovers.func_190916_E() != stack.func_190916_E()) {
                    entity.func_184185_a(SoundEvents.field_187537_bA, 0.25f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    world.func_175641_c(pos, receiver, 2, 2);
                }
                if (leftovers != null) {
                    item.func_92058_a(leftovers);
                } else {
                    entity.func_70106_y();
                }
            }
        }

        @Optional.Method(modid="thaumcraft")
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            if (ModSupport.hasThaumcraft()) {
                IForgeRegistry registry = event.getRegistry();
                BlocksMC.HUNGRY_METAL_CHEST = new BlockMetalChest(){

                    @Override
                    protected void registerResource() {
                        this.registerResource(RegistryMC.RESOURCE_HUNGRY_METAL_CHEST);
                    }

                    @Override
                    @Nullable
                    public TileEntity createTileEntity(World world, IBlockState state) {
                        return new TileHungryMetalChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
                    }

                    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
                        ServerLoader.tryToEatItem(world, pos, state, entity, this);
                    }
                };
                registry.register((IForgeRegistryEntry)BlocksMC.HUNGRY_METAL_CHEST);
                ModLoader.registerTileEntity(TileHungryMetalChest.class);
                if (ModSupport.hasRefinedRelocation()) {
                    BlocksMC.SORTING_HUNGRY_METAL_CHEST = new BlockSortingMetalChest(){

                        @Override
                        protected void registerResource() {
                            this.registerResource(RegistryMC.RESOURCE_SORTING_HUNGRY_METAL_CHEST);
                        }

                        @Override
                        @Nullable
                        public TileEntity createTileEntity(World world, IBlockState state) {
                            return new TileSortingHungryMetalChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
                        }

                        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
                            ServerLoader.tryToEatItem(world, pos, state, entity, this);
                        }
                    };
                    registry.register((IForgeRegistryEntry)BlocksMC.SORTING_HUNGRY_METAL_CHEST);
                    ModLoader.registerTileEntity(TileSortingHungryMetalChest.class);
                }
            }
        }

        @Optional.Method(modid="thaumcraft")
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            if (ModSupport.hasThaumcraft()) {
                IForgeRegistry registry = event.getRegistry();
                ModLoader.registerItemBlock((IForgeRegistry<Item>)registry, BlocksMC.HUNGRY_METAL_CHEST, ChestType.class);
                ItemsMC.HUNGRY_CHEST_UPGRADE = new ItemChestUpgrade(RegistryMC.RESOURCE_HUNGRY_CHEST_UPGRADE);
                registry.register((IForgeRegistryEntry)ItemsMC.HUNGRY_CHEST_UPGRADE);
                UpgradeRegistry.registerChest(RegistryMC.RESOURCE_HUNGRY_CHEST_UPGRADE, BlocksTC.hungryChest, BlocksMC.HUNGRY_METAL_CHEST);
                if (ModSupport.hasRefinedRelocation()) {
                    ModLoader.registerItemBlock((IForgeRegistry<Item>)registry, BlocksMC.SORTING_HUNGRY_METAL_CHEST, ChestType.class);
                }
            }
        }

        @Optional.Method(modid="thaumcraft")
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            if (ModSupport.hasThaumcraft()) {
                for (ChestType chestType : ChestType.values()) {
                    if (!chestType.isRegistered()) continue;
                    String capitalizedName = WordUtils.capitalize((String)chestType.func_176610_l());
                    OreDictionary.registerOre((String)("chestHungry" + capitalizedName), (ItemStack)new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, chestType.ordinal()));
                    if (!ModSupport.hasRefinedRelocation()) continue;
                    OreDictionary.registerOre((String)("chestSortingHungry" + capitalizedName), (ItemStack)new ItemStack(BlocksMC.SORTING_HUNGRY_METAL_CHEST, 1, chestType.ordinal()));
                }
                if (ChestType.COPPER.isRegistered()) {
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryCopperChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 0), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotCopper", Character.valueOf('C'), new ItemStack(BlocksTC.hungryChest)}));
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryIronChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 1), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 0)}));
                } else {
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryIronChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 1), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), new ItemStack(BlocksTC.hungryChest)}));
                }
                if (ChestType.SILVER.isRegistered()) {
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungrySilverChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 2), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotSilver", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 1)}));
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryGoldChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 3), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotGold", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 2)}));
                } else {
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryGoldChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 3), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "ingotGold", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 1)}));
                }
                ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryDiamondChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 4), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "gemDiamond", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 3)}));
                ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", "HungryObsidianChest"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTS", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 5), new Object[]{"III", "ICI", "III", Character.valueOf('I'), "obsidian", Character.valueOf('C'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, 4)}));
                for (Enum enum_ : ChestUpgrade.values()) {
                    ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("metalchests", ((ChestUpgrade)enum_).func_176610_l() + "_hungry_chest_upgrade"), (IArcaneRecipe)new ShapedArcaneRecipe(ModSupport.Thaumcraft.DEFAULT_GROUP, "HUNGRYMETALCHESTSUPGRADES", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(ItemsMC.HUNGRY_CHEST_UPGRADE, 1, enum_.ordinal()), new Object[]{"III", "III", "CII", Character.valueOf('I'), ((ChestUpgrade)enum_).getUpgrade().getOreName(), Character.valueOf('C'), ModLoader.getUpgradeBase(BlocksTC.plankGreatwood, ItemsMC.HUNGRY_CHEST_UPGRADE, (ChestUpgrade)enum_)}));
                }
            }
        }
    }
}

