/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.entities;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.ItemsMC;
import T145.metalchests.api.chests.IInventoryHandler;
import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ChestUpgrade;
import T145.metalchests.core.MetalChests;
import T145.metalchests.items.ItemChestUpgrade;
import T145.metalchests.tiles.TileMetalChest;
import javax.annotation.Nullable;
import mods.railcraft.api.carts.IItemCart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

@Optional.Interface(modid="railcraft", iface="mods.railcraft.api.carts.IItemCart", striprefs=true)
public class EntityMinecartMetalChest
extends EntityMinecart
implements IInventory,
IInventoryHandler,
IItemCart {
    private static final DataParameter<ChestType> CHEST_TYPE = EntityDataManager.func_187226_a(EntityMinecart.class, MetalChests.CHEST_TYPE);
    private final ItemStackHandler inventory = new ItemStackHandler(this.getChestType().getInventorySize());

    public EntityMinecartMetalChest(World world) {
        super(world);
    }

    public EntityMinecartMetalChest(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public ChestType getChestType() {
        return (ChestType)((Object)this.field_70180_af.func_187225_a(CHEST_TYPE));
    }

    public void setChestType(ChestType type) {
        this.field_70180_af.func_187227_b(CHEST_TYPE, (Object)type);
    }

    public TileMetalChest getMetalChest() {
        return new TileMetalChest(this.getChestType());
    }

    @Override
    public void setInventory(IItemHandler stacks) {
        for (int slot = 0; slot < stacks.getSlots(); ++slot) {
            if (slot >= this.getChestType().getInventorySize()) continue;
            this.inventory.setStackInSlot(slot, stacks.getStackInSlot(slot));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHEST_TYPE, (Object)ChestType.OBSIDIAN);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74778_a("Type", this.getChestType().toString());
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setChestType(ChestType.valueOf(tag.func_74779_i("Type")));
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)stack);
            }
            this.func_70099_a(new ItemStack(BlocksMC.METAL_CHEST, 1, this.getChestType().ordinal()), 0.0f);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand) || this.field_70170_p.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() instanceof ItemChestUpgrade) {
                ChestUpgrade upgrade = ChestUpgrade.byMetadata(stack.func_77952_i());
                if (this.getChestType() == upgrade.getBase()) {
                    this.setChestType(upgrade.getUpgrade());
                    this.setInventory((IItemHandler)this.inventory);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.4f, 0.8f);
                }
            }
        } else {
            player.openGui((Object)"metalchests", this.hashCode(), this.field_70170_p, 0, 0, 0);
        }
        return true;
    }

    protected void func_94101_h() {
        float f = 0.98f;
        int i = 15 - ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
        this.field_70159_w *= (double)(f += (float)i * 0.001f);
        this.field_70181_x *= 0.0;
        this.field_70179_y *= (double)f;
    }

    public ItemStack getCartItem() {
        return new ItemStack(ItemsMC.MINECART_METAL_CHEST, 1, this.getChestType().ordinal());
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, this.func_70301_a(index).func_190916_E());
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.field_70128_L && player.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.isItemValid(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public IBlockState func_180457_u() {
        return BlocksMC.METAL_CHEST.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)this.getChestType()));
    }

    public int func_94085_r() {
        return 8;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return I18n.func_74838_a((String)("item.metalchests:minecart_metal_chest." + this.getChestType().func_176610_l() + ".name"));
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="railcraft")
    public boolean canPassItemRequests() {
        return true;
    }

    @Optional.Method(modid="railcraft")
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return !ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)stack, (boolean)true).func_190926_b();
    }

    @Optional.Method(modid="railcraft")
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack extractedStack = this.inventory.extractItem(i, stack.func_190916_E(), true);
            if (!ItemStack.func_77989_b((ItemStack)extractedStack, (ItemStack)stack)) continue;
            result = extractedStack;
        }
        return !result.func_190926_b();
    }
}

