/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.items;

import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.chests.UpgradeRegistry;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ChestUpgrade;
import T145.metalchests.items.ItemMod;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemChestUpgrade
extends ItemMod {
    public ItemChestUpgrade(ResourceLocation registryName) {
        super(registryName, ChestUpgrade.values());
        this.func_77625_d(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        ChestUpgrade upgrade = ChestUpgrade.byMetadata(stack.func_77952_i());
        if (te instanceof IMetalChest) {
            IMetalChest chest = (IMetalChest)te;
            if (chest.getChestType() != upgrade.getBase() || !chest.isUpgradeApplicable(stack.func_77973_b())) return EnumActionResult.FAIL;
            ItemStackHandler oldInv = (ItemStackHandler)chest.getInventory();
            chest.setChestType(upgrade.getUpgrade());
            te.func_70296_d();
            IBlockState state = this.createBlockState(te.func_145838_q(), upgrade.getUpgrade());
            world.func_180501_a(pos, state, 3);
            world.func_184138_a(pos, state, state, 3);
            chest.setInventory((IItemHandler)oldInv);
        } else {
            if (!UpgradeRegistry.hasChest(this.getRegistryName(), te.func_145838_q())) return EnumActionResult.PASS;
            te.func_145836_u();
            EnumFacing front = this.getFrontFromProperties(world, pos);
            IItemHandler inv = this.getChestInventory(te);
            if (te instanceof TileEntityChest) {
                TileEntityChest vanillaChest = (TileEntityChest)te;
                if (vanillaChest.func_145980_j() == BlockChest.Type.TRAP) {
                    return EnumActionResult.FAIL;
                }
                vanillaChest.func_145979_i();
            }
            Block block = UpgradeRegistry.getChest(this.getRegistryName(), te.func_145838_q());
            world.func_175713_t(pos);
            world.func_175698_g(pos);
            IBlockState state = this.createBlockState(block, upgrade.getUpgrade());
            world.func_175690_a(pos, block.createTileEntity(world, state));
            world.func_180501_a(pos, state, 3);
            world.func_184138_a(pos, state, state, 3);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IMetalChest) {
                IMetalChest metalChest = (IMetalChest)tile;
                metalChest.setChestType(upgrade.getUpgrade());
                metalChest.setInventory(inv);
                metalChest.setFront(front);
                tile.func_70296_d();
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.4f, 0.8f);
        return EnumActionResult.SUCCESS;
    }

    private IItemHandler getChestInventory(TileEntity te) {
        if (te instanceof TileEntityChest) {
            return ((TileEntityChest)te).getSingleChestHandler();
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    private IBlockState createBlockState(Block upgradeBlock, ChestType upgrade) {
        return upgradeBlock.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)upgrade));
    }

    @Nullable
    private EnumFacing getFrontFromProperties(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation") || prop.func_177699_b() != EnumFacing.class) continue;
            IProperty facingProperty = prop;
            return (EnumFacing)state.func_177229_b(facingProperty);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void prepareCreativeTab(NonNullList<ItemStack> items) {
        for (ChestUpgrade upgrade : ChestUpgrade.values()) {
            if (!upgrade.isRegistered()) continue;
            items.add((Object)new ItemStack((Item)this, 1, upgrade.ordinal()));
        }
    }
}

