/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.control.energy;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import wanion.lib.common.control.IControl;

public class EnergyControl
implements IEnergyStorage,
IControl<EnergyControl> {
    private final int capacity;
    private final int baseEnergyUsage;
    private int energy;

    public EnergyControl(int capacity, int baseEnergyUsage) {
        this(capacity, baseEnergyUsage, 0);
    }

    public EnergyControl(int capacity, int baseEnergyUsage, int energy) {
        this.capacity = capacity;
        this.baseEnergyUsage = baseEnergyUsage;
        this.energy = energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.capacity, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    private void useEnergy(int energy) {
        this.energy -= energy;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergyStored() >= this.baseEnergyUsage;
    }

    @Override
    public void operate() {
        this.useEnergy(this.baseEnergyUsage);
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("Energy", this.energy);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("Energy")) {
            this.setEnergyStored(nbtTagCompound.func_74762_e("Energy"));
        }
    }

    @Override
    @Nonnull
    public EnergyControl copy() {
        return new EnergyControl(this.capacity, this.baseEnergyUsage, this.energy);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EnergyControl && this.energy == ((EnergyControl)obj).energy;
    }
}

