/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiCCButton;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.gui.GuiScreenWidget;
import codechicken.lib.gui.GuiScrollSlot;
import codechicken.lib.gui.GuiWidget;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionList;
import codechicken.nei.config.OptionScrollPane;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class GuiOptionList
extends GuiScreenWidget {
    protected final GuiScreen parent;
    protected final OptionList optionList;
    protected boolean world;
    protected OptionScrollSlot slot;
    protected GuiCCButton backButton;
    protected GuiCCButton worldButton;

    public GuiOptionList(GuiScreen parent, OptionList optionList, boolean world) {
        this.parent = parent;
        this.optionList = optionList;
        this.world = world;
    }

    public void func_73866_w_() {
        this.xSize = this.field_146294_l;
        this.ySize = this.field_146295_m;
        super.func_73866_w_();
    }

    public void resize() {
        this.slot.resize();
        this.backButton.width = Math.min(200, this.field_146294_l - 40);
        this.backButton.x = (this.field_146294_l - this.backButton.width) / 2;
        this.backButton.y = this.field_146295_m - 25;
        this.worldButton.width = 60;
        this.worldButton.x = this.field_146294_l - this.worldButton.width - 15;
    }

    public void addWidgets() {
        this.slot = new OptionScrollSlot();
        this.add((GuiWidget)this.slot);
        this.backButton = new GuiCCButton(0, 0, 0, 20, I18n.func_74838_a((String)"nei.options.back")).setActionCommand("back");
        this.add((GuiWidget)this.backButton);
        this.worldButton = new GuiCCButton(0, 2, 0, 16, this.worldButtonName()).setActionCommand("world");
        this.add((GuiWidget)this.worldButton);
    }

    private String worldButtonName() {
        return I18n.func_74838_a((String)("nei.options." + (this.world ? "world" : "global")));
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("back")) {
            if (this.parent instanceof GuiOptionList) {
                ((GuiOptionList)this.parent).world = this.world;
            }
            Minecraft.func_71410_x().func_147108_a(this.parent);
        } else if (ident.equals("world")) {
            this.world = !this.world;
            this.worldButton.text = this.worldButtonName();
        }
    }

    public void drawBackground() {
        this.func_146276_q_();
    }

    public void drawForeground() {
        this.func_73732_a(this.field_146289_q, I18n.func_74838_a((String)this.optionList.fullName()), this.field_146294_l / 2, 6, -1);
        this.drawTooltip();
    }

    private void drawTooltip() {
        List<String> tooltip = new LinkedList<String>();
        Point mouse = GuiDraw.getMousePosition();
        if (this.worldButton.pointInside(mouse.x, mouse.y)) {
            tooltip.addAll(Arrays.asList(I18n.func_74838_a((String)("nei.options.global.tip." + (this.world ? "1" : "0"))).split(":")));
        }
        tooltip = this.slot.handleTooltip(mouse.x, mouse.y, tooltip);
        GuiDraw.drawMultiLineTip((ItemStack)ItemStack.field_190927_a, (int)(mouse.x + 12), (int)(mouse.y - 12), tooltip);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73869_a(char c, int keycode) throws IOException {
        if (keycode == 1) {
            GuiScreen p = this.parent;
            while (p instanceof GuiOptionList) {
                p = ((GuiOptionList)p).parent;
            }
            Minecraft.func_71410_x().func_147108_a(p);
        } else {
            super.func_73869_a(c, keycode);
        }
    }

    public boolean worldConfig() {
        return this.world;
    }

    public class OptionScrollSlot
    extends GuiScrollSlot {
        public ArrayList<Option> options;

        public OptionScrollSlot() {
            super(0, 0, 0, 0);
            this.options = new ArrayList();
            this.setMargins(0, 4, 20, 4);
        }

        public void onAdded(GuiScreen s) {
            super.onAdded(s);
            for (Option o : GuiOptionList.this.optionList.optionList) {
                this.options.add(o);
            }
            for (Option o : this.options) {
                o.onAdded(this);
            }
        }

        public int getSlotHeight(int slot) {
            return this.options.get(slot).getHeight() + 4;
        }

        public int slotWidth() {
            return this.windowBounds().width - 24;
        }

        private Rectangle slotBounds(int slot) {
            return new Rectangle(24, 2, this.slotWidth(), this.getSlotHeight(slot) - 4);
        }

        protected int getNumSlots() {
            return this.options.size();
        }

        protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
            Option o = this.options.get(slot);
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            if (o.showWorldSelector() && GuiOptionList.this.world) {
                this.drawWorldSelector(o, mx, my);
            }
            GlStateManager.func_179109_b((float)24.0f, (float)2.0f, (float)0.0f);
            o.draw(mx - 24, my - 2, frame);
            GlStateManager.func_179109_b((float)(-x - 24), (float)(-y - 2), (float)0.0f);
        }

        public Rectangle4i worldButtonSize() {
            return new Rectangle4i(0, 2, 20, 20);
        }

        private void drawWorldSelector(Option o, int mousex, int mousey) {
            Rectangle4i b = this.worldButtonSize();
            boolean set = o.hasWorldOverride();
            boolean mouseover = b.contains(mousex, mousey);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, !set ? 0 : (mouseover ? 2 : 1));
            GuiDraw.drawStringC((String)"W", (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)-1);
        }

        public void drawBackground(float frame) {
            Rectangle sbar = this.scrollbarBounds();
            OptionScrollSlot.func_73734_a((int)sbar.x, (int)this.y, (int)(sbar.x + sbar.width), (int)(this.y + this.height), (int)-16777216);
        }

        public void drawOverlay(float frame) {
            OptionScrollPane.drawOverlay(this.y, this.height, this.parentScreen.field_146294_l, this.field_73735_i);
        }

        public int scrollbarGuideAlignment() {
            return 0;
        }

        public Dimension scrollbarDim() {
            Dimension dim = super.scrollbarDim();
            dim.width = 6;
            return dim;
        }

        public void update() {
            super.update();
            for (Option o : this.options) {
                o.update();
            }
        }

        protected void slotClicked(int slot, int button, int mx, int my, int count) {
            Option o = this.options.get(slot);
            if (GuiOptionList.this.world && o.showWorldSelector() && this.worldButtonSize().contains(mx, my)) {
                if (button == 1 && o.hasWorldOverride()) {
                    o.useGlobals();
                    Option.playClickSound();
                } else if (button == 0 && !o.hasWorldOverride()) {
                    o.copyGlobals();
                    Option.playClickSound();
                }
            } else if (this.slotBounds(slot).contains(mx, my)) {
                this.options.get(slot).mouseClicked(mx - 24, my - 2, button);
            }
        }

        public void mouseClicked(int mx, int my, int button) {
            for (Option o : this.options) {
                o.onMouseClicked(mx, my, button);
            }
            super.mouseClicked(mx, my, button);
        }

        public void keyTyped(char c, int keycode) {
            super.keyTyped(c, keycode);
            for (Option o : this.options) {
                o.keyTyped(c, keycode);
            }
        }

        public void resize() {
            int width = Math.min(this.parentScreen.field_146294_l - 80, 320);
            this.setSize((this.parentScreen.field_146294_l - width) / 2, 20, width, this.parentScreen.field_146295_m - 50);
        }

        public void mouseScrolled(int x, int y, int scroll) {
            this.scroll(-scroll);
        }

        public GuiOptionList getGui() {
            return (GuiOptionList)this.parentScreen;
        }

        public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
            int sy = my - this.y + this.scrolledPixels();
            int slot = this.getSlot(sy);
            if (slot >= 0) {
                tooltip = this.handleTooltip(slot, mx - this.x, sy - this.getSlotY(slot), tooltip);
            }
            return tooltip;
        }

        private List<String> handleTooltip(int slot, int mx, int my, List<String> tooltip) {
            Option o = this.options.get(slot);
            if (GuiOptionList.this.world && o.showWorldSelector() && this.worldButtonSize().contains(mx, my)) {
                tooltip.add(I18n.func_74838_a((String)("nei.options.wbutton.tip." + (o.hasWorldOverride() ? "1" : "0"))));
            }
            if (this.slotBounds(slot).contains(mx, my)) {
                return o.handleTooltip(mx - 24, my - 2, tooltip);
            }
            return tooltip;
        }
    }
}

