/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.network;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.nei.ClientHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.container.ContainerCreativeInv;
import codechicken.nei.container.ExtendedCreativeInv;
import codechicken.nei.gui.GuiEnchantmentModifier;
import codechicken.nei.gui.GuiExtendedCreativeInv;
import codechicken.nei.gui.GuiPotionCreator;
import codechicken.nei.handler.MagnetModeHandler;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.NEIServerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class NEIClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient netHandler) {
        switch (packet.getType()) {
            case 1: {
                this.handleServerSideCheck(packet.readUByte(), packet.readString(), (World)mc.field_71441_e);
                break;
            }
            case 10: {
                this.handleLoginState(packet);
                break;
            }
            case 11: {
                this.handleActionDisableStateChange(packet);
                break;
            }
            case 12: {
                this.handleActionEnabled(packet);
                break;
            }
            case 13: {
                MagnetModeHandler.INSTANCE.trackMagnetItem(packet.readInt(), (World)mc.field_71441_e);
                break;
            }
            case 14: {
                this.handleGameMode(mc, packet.readUByte());
                break;
            }
            case 21: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiEnchantmentModifier(mc.field_71439_g.field_71071_by, (World)mc.field_71441_e));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiExtendedCreativeInv(new ContainerCreativeInv((EntityPlayer)mc.field_71439_g, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)mc.field_71439_g));
                break;
            }
            case 24: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiPotionCreator(mc.field_71439_g.field_71071_by));
            }
        }
    }

    private void handleGameMode(Minecraft mc, int mode) {
        mc.field_71442_b.func_78746_a(NEIServerUtils.getGameType(mode));
    }

    private void handleActionEnabled(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.enabledActions.add(name);
        } else {
            NEIClientConfig.enabledActions.remove(name);
        }
    }

    private void handleActionDisableStateChange(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.disabledActions.add(name);
        } else {
            NEIClientConfig.disabledActions.remove(name);
        }
    }

    private void handleLoginState(PacketCustom packet) {
        int i;
        NEIClientConfig.permissibleActions.clear();
        int num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.permissibleActions.add(packet.readString());
        }
        NEIClientConfig.disabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.disabledActions.add(packet.readString());
        }
        NEIClientConfig.enabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.enabledActions.add(packet.readString());
        }
        NEIClientConfig.bannedItems.clear();
        num = packet.readInt();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.bannedItems.add(packet.readItemStack());
        }
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handleServerSideCheck(int serverProtocol, String worldName, World world) {
        if (serverProtocol > 0) {
            NEIClientUtils.printChatMessage((ITextComponent)new TextComponentTranslation("nei.chat.mismatch.client", new Object[0]));
        } else if (serverProtocol < 0) {
            NEIClientUtils.printChatMessage((ITextComponent)new TextComponentTranslation("nei.chat.mismatch.server", new Object[0]));
        } else {
            try {
                ClientHandler.INSTANCE.loadWorld(world);
                NEIClientConfig.loadWorld(NEIClientPacketHandler.getSaveName(worldName));
                NEIClientConfig.setHasSMPCounterPart(true);
                NEIClientPacketHandler.sendRequestLoginInfo();
            }
            catch (Exception e) {
                LogHelper.errorError("Error handling SMP Check", e);
            }
        }
    }

    private static String getSaveName(String worldName) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return "local/" + ClientUtils.getWorldSaveName();
        }
        return "remote/" + ClientUtils.getServerIP().replace(':', '~') + "/" + worldName;
    }

    public static void sendGiveItem(ItemStack stack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeItemStack(stack);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        packet.sendToServer();
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom((Object)channel, 4);
        packet.sendToServer();
    }

    @Deprecated
    public static void sendStateLoad(ItemStack[] state) {
        NEIClientPacketHandler.sendDeleteAllItems();
        for (int slot = 0; slot < state.length; ++slot) {
            ItemStack item = state[slot];
            if (item.func_190926_b()) continue;
            NEIClientPacketHandler.sendSetSlot(slot, item, false);
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.sendToServer();
    }

    public static void sendSetSlot(int slot, ItemStack stack, boolean container) {
        PacketCustom packet = new PacketCustom((Object)channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.sendToServer();
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.sendToServer();
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(hour);
        packet.sendToServer();
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom((Object)channel, 8);
        packet.sendToServer();
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom((Object)channel, 9);
        packet.sendToServer();
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom((Object)channel, 21);
        packet.sendToServer();
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom((Object)channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        packet.sendToServer();
    }

    public static void sendActionDisableStateChange(String name, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeString(name);
        packet.writeBoolean(enable);
        packet.sendToServer();
    }

    public static void sendGameMode(int mode) {
        new PacketCustom((Object)channel, 13).writeByte(mode).sendToServer();
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 23);
        packet.writeBoolean(open);
        packet.sendToServer();
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom((Object)channel, 14);
        packet.writeInt(steps);
        packet.sendToServer();
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom((Object)channel, 15);
        packet.writePos(new BlockPos(x, y, z));
        packet.writeString(mobtype);
        packet.sendToServer();
    }

    public static PacketCustom createContainerPacket() {
        return new PacketCustom((Object)channel, 20);
    }

    public static void sendOpenPotionWindow() {
        Object[] potionStore = new ItemStack[9];
        ArrayUtils.fillArray((Object[])potionStore, (Object)ItemStack.field_190927_a);
        InventoryUtils.readItemStacksFromTag((ItemStack[])potionStore, (NBTTagList)NEIClientConfig.global.nbt.func_74775_l("potionStore").func_150295_c("items", 10));
        PacketCustom packet = new PacketCustom((Object)channel, 24);
        for (Object stack : potionStore) {
            packet.writeItemStack((ItemStack)stack);
        }
        packet.sendToServer();
    }

    public static void sendDummySlotSet(int slotNumber, ItemStack stack) {
        PacketCustom packet = new PacketCustom((Object)channel, 25);
        packet.writeShort(slotNumber);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }
}

