/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.arboriculture.blocks.BlockForestryLog;
import forestry.arboriculture.blocks.PropertyForestryWoodType;
import java.util.ArrayList;
import java.util.List;

public abstract class BlockArbLog
extends BlockForestryLog<EnumForestryWoodType> {
    public static List<BlockArbLog> create(boolean fireproof) {
        ArrayList<BlockArbLog> blocks = new ArrayList<BlockArbLog>();
        PropertyForestryWoodType[] variants = PropertyForestryWoodType.create("variant", 4);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyForestryWoodType variant = variants[i];
            BlockArbLog block = new BlockArbLog(fireproof, i){

                public PropertyForestryWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockArbLog(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
    }

    @Override
    public EnumForestryWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 4;
        return EnumForestryWoodType.byMetadata(variantMeta);
    }
}

