/*
 * Decompiled with CFR 0.152.
 */
package forestry.book;

import forestry.api.book.BookContent;
import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IBookEntryBuilder;
import forestry.api.book.IBookPageFactory;
import forestry.book.BookEntry;
import forestry.book.pages.JsonPageFactory;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BookEntryBuilder
implements IBookEntryBuilder {
    private final String name;
    private final IBookCategory category;
    private ItemStack stack = ItemStack.field_190927_a;
    private IBookPageFactory loader = JsonPageFactory.INSTANCE;
    private List<IBookEntryBuilder> subEntries = new LinkedList<IBookEntryBuilder>();
    private String title = "missing.title";
    private BookContent[][] content = new BookContent[0][0];

    BookEntryBuilder(IBookCategory category, String name) {
        this.category = category;
        this.name = name;
    }

    @Override
    public BookEntryBuilder setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    @Override
    public BookEntryBuilder setLoader(IBookPageFactory loader) {
        this.loader = loader;
        return this;
    }

    @Override
    public BookEntryBuilder createSubEntry(String name, ItemStack stack) {
        BookEntryBuilder builder = new BookEntryBuilder(this.category, name).setStack(stack);
        this.subEntries.add(builder);
        return builder;
    }

    @Override
    public IBookEntryBuilder setContent(BookContent[][] content) {
        this.content = content;
        return this;
    }

    @Override
    public IBookEntryBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public IBookEntry build(@Nullable IBookEntry parent) {
        return new BookEntry(this.name, this.stack, this.loader, entry -> (IBookEntry[])this.subEntries.stream().map(builder -> builder.build((IBookEntry)entry)).toArray(IBookEntry[]::new), this.content, this.title, parent);
    }

    @Override
    public IBookEntry build() {
        return this.build(null);
    }

    @Override
    public IBookCategory addToCategory() {
        this.category.addEntry(this.build());
        return this.category;
    }
}

