/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.api.immutable;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public enum ChestType implements IStringSerializable
{
    COPPER(InventorySize.COPPER, MapColor.field_151658_d, SoundType.field_185852_e, "ingotCopper"),
    IRON(InventorySize.IRON, MapColor.field_151668_h, SoundType.field_185852_e, "ingotIron"),
    SILVER(InventorySize.SILVER, MapColor.field_151680_x, SoundType.field_185852_e, "ingotSilver"),
    GOLD(InventorySize.GOLD, MapColor.field_151647_F, SoundType.field_185852_e, "ingotGold"),
    DIAMOND(InventorySize.DIAMOND, MapColor.field_151648_G, SoundType.field_185852_e, "gemDiamond"),
    OBSIDIAN(InventorySize.DIAMOND, Material.field_151576_e, MapColor.field_151654_J, SoundType.field_185851_d, "obsidian");

    private final InventorySize invSize;
    private final Material material;
    private final MapColor color;
    private final SoundType sound;
    private final String dictName;

    private ChestType(InventorySize invSize, Material material, MapColor color, SoundType sound, String dictName) {
        this.invSize = invSize;
        this.material = material;
        this.color = color;
        this.sound = sound;
        this.dictName = dictName;
    }

    private ChestType(InventorySize invSize, MapColor color, SoundType sound, String dictName) {
        this(invSize, Material.field_151573_f, color, sound, dictName);
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public int getInventorySize() {
        return this.invSize.size;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MapColor getMapColor() {
        return this.color;
    }

    public SoundType getSoundType() {
        return this.sound;
    }

    public String getOreName() {
        return this.dictName;
    }

    public boolean isRegistered() {
        return OreDictionary.doesOreNameExist((String)this.dictName) && !OreDictionary.getOres((String)this.dictName).isEmpty();
    }

    public boolean isLarge() {
        return this.getInventorySize() > 100;
    }

    public int getRowLength() {
        return this.isLarge() ? 12 : 9;
    }

    public int getRowCount() {
        return this.getInventorySize() / this.getRowLength();
    }

    public static ChestType byMetadata(int meta) {
        return ChestType.values()[meta];
    }

    public GUI getGui() {
        return GUI.byType(this);
    }

    public String getGuiId() {
        return "metalchests:" + this.func_176610_l() + "_chest";
    }

    public static enum GUI {
        COPPER(184),
        IRON(202),
        SILVER(238),
        GOLD(256),
        DIAMOND(256),
        OBSIDIAN(256);

        private final int ySize;

        private GUI(int ySize) {
            this.ySize = ySize;
        }

        public int getSizeX() {
            return ChestType.byMetadata(this.ordinal()).isLarge() ? 238 : 184;
        }

        public int getSizeY() {
            return this.ySize;
        }

        public static GUI byMetadata(int meta) {
            return GUI.values()[meta];
        }

        public static GUI byType(ChestType type) {
            return GUI.byMetadata(type.ordinal());
        }

        public ResourceLocation getGuiTexture() {
            ChestType type = ChestType.byMetadata(this.ordinal());
            return new ResourceLocation("metalchests", "textures/gui/" + (type.isLarge() ? "diamond" : type.func_176610_l()) + "_container.png");
        }
    }

    static enum InventorySize {
        COPPER(45),
        IRON(54),
        SILVER(72),
        GOLD(81),
        DIAMOND(108);

        private final int size;

        private InventorySize(int size) {
            this.size = size;
        }
    }
}

