/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.EntitiesMC;
import T145.metalchests.api.ItemsMC;
import T145.metalchests.api.chests.UpgradeRegistry;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ChestUpgrade;
import T145.metalchests.api.immutable.ModSupport;
import T145.metalchests.api.immutable.RegistryMC;
import T145.metalchests.blocks.BlockMetalChest;
import T145.metalchests.blocks.BlockModItem;
import T145.metalchests.client.render.blocks.RenderMetalChest;
import T145.metalchests.client.render.entities.RenderMinecartMetalChest;
import T145.metalchests.config.ModConfig;
import T145.metalchests.core.UpdateChecker;
import T145.metalchests.entities.EntityMinecartMetalChest;
import T145.metalchests.entities.ai.EntityAIOcelotSitOnChest;
import T145.metalchests.items.ItemChestUpgrade;
import T145.metalchests.items.ItemMetalMinecart;
import T145.metalchests.tiles.TileMetalChest;
import java.util.HashSet;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class ModLoader {
    public static void registerTileEntity(Class tileClass) {
        GameRegistry.registerTileEntity((Class)tileClass, (ResourceLocation)new ResourceLocation("metalchests", tileClass.getSimpleName()));
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block, Class types) {
        registry.register(new BlockModItem(block, types).setRegistryName(block.getRegistryName()));
    }

    public static String getVariantName(IStringSerializable variant) {
        return "variant=" + variant.func_176610_l();
    }

    public static Object getUpgradeBase(Object base, Item upgrade, ChestUpgrade type) {
        switch (type) {
            case WOOD_COPPER: {
                return base;
            }
            case WOOD_IRON: {
                if (ChestType.COPPER.isRegistered()) break;
                return base;
            }
            case WOOD_GOLD: {
                if (ChestType.SILVER.isRegistered()) break;
                return new ItemStack(upgrade, 1, ChestUpgrade.WOOD_IRON.ordinal());
            }
            case COPPER_IRON: 
            case IRON_SILVER: 
            case SILVER_GOLD: 
            case GOLD_DIAMOND: 
            case DIAMOND_OBSIDIAN: {
                return type.getBase().getOreName();
            }
            case COPPER_GOLD: {
                if (ChestType.SILVER.isRegistered()) break;
                return new ItemStack(upgrade, 1, ChestUpgrade.COPPER_IRON.ordinal());
            }
            case IRON_GOLD: {
                if (ChestType.SILVER.isRegistered()) break;
                return type.getBase().getOreName();
            }
        }
        return new ItemStack(upgrade, 1, type.ordinal() - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getCustomModel(Item item, String customDomain, StringBuilder variantPath) {
        if (StringUtils.func_151246_b((String)customDomain)) {
            return new ModelResourceLocation(item.getRegistryName(), variantPath.toString());
        }
        return new ModelResourceLocation("metalchests:" + customDomain, variantPath.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, String customDomain, int meta, String ... variants) {
        StringBuilder variantPath = new StringBuilder(variants[0]);
        for (int i = 1; i < variants.length; ++i) {
            variantPath.append(',').append(variants[i]);
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ModLoader.getCustomModel(item, customDomain, variantPath));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Block block, String customDomain, int meta, String ... variants) {
        ModLoader.registerModel(Item.func_150898_a((Block)block), customDomain, meta, variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String ... variants) {
        ModLoader.registerModel(item, null, meta, variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Block block, int meta, String ... variants) {
        ModLoader.registerModel(block, null, meta, variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerTileRenderer(Class tileClass, TileEntitySpecialRenderer tileRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)tileClass, (TileEntitySpecialRenderer)tileRenderer);
    }

    @Mod.EventBusSubscriber(modid="metalchests", value={Side.CLIENT})
    static class ClientLoader {
        ClientLoader() {
        }

        @SubscribeEvent
        public static void onModelRegistration(ModelRegistryEvent event) {
            for (ChestType chestType : ChestType.values()) {
                ModLoader.registerModel(BlocksMC.METAL_CHEST, chestType.ordinal(), ModLoader.getVariantName(chestType));
                if (!ModConfig.GENERAL.enableMinecarts) continue;
                ModLoader.registerModel(ItemsMC.MINECART_METAL_CHEST, "item_minecart", chestType.ordinal(), "item=" + chestType.func_176610_l() + "_chest");
            }
            ModLoader.registerTileRenderer(TileMetalChest.class, RenderMetalChest.INSTANCE);
            for (Enum enum_ : ChestUpgrade.values()) {
                ModLoader.registerModel(ItemsMC.CHEST_UPGRADE, "item_chest_upgrade", enum_.ordinal(), "item=" + ((ChestUpgrade)enum_).func_176610_l());
            }
            RenderingRegistry.registerEntityRenderingHandler(EntityMinecartMetalChest.class, manager -> new RenderMinecartMetalChest(manager));
        }
    }

    @Mod.EventBusSubscriber(modid="metalchests")
    static class ServerLoader {
        ServerLoader() {
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            BlocksMC.METAL_CHEST = new BlockMetalChest();
            registry.register((IForgeRegistryEntry)BlocksMC.METAL_CHEST);
            ModLoader.registerTileEntity(TileMetalChest.class);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            ModLoader.registerItemBlock((IForgeRegistry<Item>)registry, BlocksMC.METAL_CHEST, ChestType.class);
            ItemsMC.CHEST_UPGRADE = new ItemChestUpgrade(RegistryMC.RESOURCE_CHEST_UPGRADE);
            registry.register((IForgeRegistryEntry)ItemsMC.CHEST_UPGRADE);
            if (ModSupport.hasRefinedRelocation()) {
                UpgradeRegistry.registerChest(RegistryMC.RESOURCE_CHEST_UPGRADE, ModBlocks.sortingChest, BlocksMC.SORTING_METAL_CHEST);
            }
            if (ModConfig.GENERAL.enableMinecarts) {
                ItemsMC.MINECART_METAL_CHEST = new ItemMetalMinecart();
                registry.register((IForgeRegistryEntry)ItemsMC.MINECART_METAL_CHEST);
            }
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            IForgeRegistry registry = event.getRegistry();
            if (ModConfig.GENERAL.enableMinecarts) {
                EntitiesMC.MINECART_METAL_CHEST = EntityEntryBuilder.create().id("minecart_metal_chest", 0).name("minecart_metal_chest").entity(EntityMinecartMetalChest.class).tracker(80, 3, true).build();
                registry.register((IForgeRegistryEntry)EntitiesMC.MINECART_METAL_CHEST);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            for (ChestType chestType : ChestType.values()) {
                if (!chestType.isRegistered()) continue;
                OreDictionary.registerOre((String)("chest" + WordUtils.capitalize((String)chestType.func_176610_l())), (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, chestType.ordinal()));
            }
            for (ChestType chestType : ChestType.values()) {
                if (!chestType.isRegistered()) continue;
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_minecart_chest_" + chestType.func_176610_l()), null, (ItemStack)new ItemStack(ItemsMC.MINECART_METAL_CHEST, 1, chestType.ordinal()), (Object[])new Object[]{"a", "b", Character.valueOf('a'), new ItemStack(BlocksMC.METAL_CHEST, 1, chestType.ordinal()), Character.valueOf('b'), Items.field_151143_au});
            }
            if (ChestType.COPPER.isRegistered()) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.COPPER.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.COPPER.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotCopper", Character.valueOf('b'), "chestWood"});
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.IRON.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.IRON.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotIron", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.COPPER.ordinal())});
            } else {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.IRON.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.IRON.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotIron", Character.valueOf('b'), "chestWood"});
            }
            if (ChestType.SILVER.isRegistered()) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.SILVER.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.SILVER.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotSilver", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.IRON.ordinal())});
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.GOLD.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.GOLD.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotGold", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.SILVER.ordinal())});
            } else {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.GOLD.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.GOLD.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "ingotGold", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.IRON.ordinal())});
            }
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.DIAMOND.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.DIAMOND.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "gemDiamond", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.GOLD.ordinal())});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_" + ChestType.OBSIDIAN.func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.OBSIDIAN.ordinal()), (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), "obsidian", Character.valueOf('b'), new ItemStack(BlocksMC.METAL_CHEST, 1, ChestType.DIAMOND.ordinal())});
            for (Enum enum_ : ChestUpgrade.values()) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_chest_upgrade_" + ((ChestUpgrade)enum_).func_176610_l()), null, (ItemStack)new ItemStack(ItemsMC.CHEST_UPGRADE, 1, enum_.ordinal()), (Object[])new Object[]{"aaa", "aaa", "baa", Character.valueOf('a'), ((ChestUpgrade)enum_).getUpgrade().getOreName(), Character.valueOf('b'), ModLoader.getUpgradeBase("plankWood", ItemsMC.CHEST_UPGRADE, (ChestUpgrade)enum_)});
            }
            if (ModSupport.hasRefinedRelocation()) {
                for (Enum enum_ : ChestType.values()) {
                    if (!((ChestType)enum_).isRegistered()) continue;
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_sorting_chest_" + ((ChestType)enum_).func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.SORTING_METAL_CHEST, 1, enum_.ordinal()), (Object[])new Object[]{" a ", "bcb", " d ", Character.valueOf('a'), Items.field_151099_bA, Character.valueOf('b'), Items.field_151137_ax, Character.valueOf('c'), new ItemStack(BlocksMC.METAL_CHEST, 1, enum_.ordinal()), Character.valueOf('d'), Blocks.field_150438_bZ});
                    if (!ModSupport.hasThaumcraft()) continue;
                    GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("metalchests", "recipe_sorting_hungry_chest_" + ((ChestType)enum_).func_176610_l()), null, (ItemStack)new ItemStack(BlocksMC.SORTING_HUNGRY_METAL_CHEST, 1, enum_.ordinal()), (Object[])new Object[]{" a ", "bcb", " d ", Character.valueOf('a'), Items.field_151099_bA, Character.valueOf('b'), Items.field_151137_ax, Character.valueOf('c'), new ItemStack(BlocksMC.HUNGRY_METAL_CHEST, 1, enum_.ordinal()), Character.valueOf('d'), Blocks.field_150438_bZ});
                }
            }
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("metalchests")) {
                ConfigManager.sync((String)"metalchests", (Config.Type)Config.Type.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (ModConfig.GENERAL.checkForUpdates && UpdateChecker.hasUpdate()) {
                event.player.func_145747_a(UpdateChecker.getUpdateNotification());
            }
        }

        @SubscribeEvent
        public static void changeSittingTaskForOcelots(LivingEvent.LivingUpdateEvent event) {
            EntityLivingBase creature = event.getEntityLiving();
            if (creature instanceof EntityOcelot && creature.field_70173_aa < 5) {
                EntityOcelot ocelot = (EntityOcelot)creature;
                HashSet<EntityAITasks.EntityAITaskEntry> tasks = new HashSet<EntityAITasks.EntityAITaskEntry>();
                for (EntityAITasks.EntityAITaskEntry task : ocelot.field_70714_bg.field_75782_a) {
                    if (task.field_75733_a.getClass() != EntityAIOcelotSit.class) continue;
                    tasks.add(task);
                }
                for (EntityAITasks.EntityAITaskEntry task : tasks) {
                    ocelot.field_70714_bg.func_85156_a(task.field_75733_a);
                    ocelot.field_70714_bg.func_75776_a(task.field_75731_b, (EntityAIBase)new EntityAIOcelotSitOnChest(ocelot, 0.4f));
                }
            }
        }
    }
}

