/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.tiles;

import T145.metalchests.api.ItemsMC;
import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.immutable.ChestType;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.dries007.holoInventory.api.INamedItemHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.quark.api.IDropoffManager;

@Optional.InterfaceList(value={@Optional.Interface(modid="holoinventory", iface="net.dries007.holoInventory.api.INamedItemHandler", striprefs=true), @Optional.Interface(modid="quark", iface="vazkii.quark.api.IDropoffManager", striprefs=true)})
public class TileMetalChest
extends TileEntity
implements IMetalChest,
ITickable,
INamedItemHandler,
IDropoffManager {
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    protected ChestType chestType;
    protected EnumFacing front;
    protected ItemStackHandler inventory;

    public TileMetalChest(ChestType chestType) {
        this.setChestType(chestType);
        this.setFront(EnumFacing.EAST);
        this.inventory = this.initInventory();
    }

    public TileMetalChest() {
        this(ChestType.IRON);
    }

    protected ItemStackHandler initInventory() {
        return new ItemStackHandler(this.chestType.getInventorySize()){

            protected void onContentsChanged(int slot) {
                TileMetalChest.this.func_70296_d();
                TileMetalChest.this.field_145850_b.func_175666_e(TileMetalChest.this.field_174879_c, TileMetalChest.this.func_145838_q());
            }
        };
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    @Override
    public ChestType getChestType() {
        return this.chestType;
    }

    @Override
    public void setChestType(ChestType chestType) {
        this.chestType = chestType;
    }

    @Override
    public boolean isUpgradeApplicable(Item upgrade) {
        return upgrade.getRegistryName().equals((Object)ItemsMC.CHEST_UPGRADE.getRegistryName());
    }

    @Override
    public EnumFacing getFront() {
        return this.front;
    }

    @Override
    public void setFront(EnumFacing front) {
        this.front = front;
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventory(IItemHandler inventory) {
        this.inventory = this.initInventory();
        assert (this.inventory.getSlots() >= inventory.getSlots());
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            this.inventory.setStackInSlot(slot, inventory.getStackInSlot(slot));
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(cap, side);
    }

    @Override
    public void openInventory(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, ++this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, false);
            this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public void closeInventory(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, --this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, false);
            this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    private static float approachLinear(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = TileMetalChest.approachLinear(this.lidAngle, this.numPlayersUsing > 0 ? 1.0f : 0.0f, 0.1f);
    }

    @OverridingMethodsMustInvokeSuper
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setChestType(ChestType.valueOf(tag.func_74779_i("ChestType")));
        this.setFront(EnumFacing.func_176739_a((String)tag.func_74779_i("Front")));
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
    }

    @OverridingMethodsMustInvokeSuper
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74778_a("ChestType", this.chestType.toString());
        tag.func_74778_a("Front", this.front.toString());
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public boolean func_145842_c(int id, int data) {
        switch (id) {
            case 1: {
                this.numPlayersUsing = data;
                return true;
            }
        }
        return false;
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public String getTranslationKey() {
        return "tile.metalchests:metal_chest." + this.chestType.func_176610_l() + ".name";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getTranslationKey(), new Object[0]);
    }

    @Optional.Method(modid="holoinventory")
    public String getItemHandlerName() {
        return this.getTranslationKey();
    }

    @Optional.Method(modid="quark")
    public boolean acceptsDropoff(EntityPlayer player) {
        return true;
    }

    @Optional.Method(modid="quark")
    public IItemHandler getDropoffItemHandler(Supplier<IItemHandler> defaultSupplier) {
        return this.inventory;
    }
}

