/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.tiles;

import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.tiles.TileMetalChest;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.INameTaggable;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.ItemStackHandler;

public class TileSortingMetalChest
extends TileMetalChest
implements INameTaggable {
    protected ISortingInventory sortingInventory = (ISortingInventory)Capabilities.getDefaultInstance((Capability)Capabilities.SORTING_INVENTORY);
    protected IRootFilter rootFilter = (IRootFilter)Capabilities.getDefaultInstance((Capability)Capabilities.ROOT_FILTER);
    protected String customName = "";

    public TileSortingMetalChest(ChestType chestType) {
        super(chestType);
    }

    public TileSortingMetalChest() {
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new ItemStackHandler(this.chestType.getInventorySize()){

            protected void onContentsChanged(int slot) {
                TileSortingMetalChest.this.func_70296_d();
                TileSortingMetalChest.this.sortingInventory.onSlotChanged(slot);
                TileSortingMetalChest.this.field_145850_b.func_175666_e(TileSortingMetalChest.this.field_174879_c, TileSortingMetalChest.this.func_145838_q());
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.sortingInventory.onLoad((TileEntity)this);
    }

    @Override
    public void func_73660_a() {
        this.sortingInventory.onUpdate((TileEntity)this);
        super.func_73660_a();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate((TileEntity)this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.sortingInventory.onInvalidate((TileEntity)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY || capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY) {
            return (T)this.sortingInventory;
        }
        if (capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY) {
            return (T)this.rootFilter;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        this.setCustomName(compound.func_74779_i("CustomName"));
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        if (compound.func_150299_b("RootFilter") == 9) {
            NBTTagList tagList = compound.func_150295_c("RootFilter", 10);
            compound.func_82580_o("RootFilter");
            NBTTagCompound rootFilter = new NBTTagCompound();
            rootFilter.func_74782_a("FilterList", (NBTBase)tagList);
            compound.func_74782_a("RootFilter", (NBTBase)rootFilter);
        }
        this.rootFilter.deserializeNBT((NBTBase)compound.func_74775_l("RootFilter"));
        this.customName = compound.func_74779_i("CustomName");
    }

    @Override
    public String getTranslationKey() {
        return "tile.metalchests:sorting_metal_chest." + this.chestType.func_176610_l() + ".name";
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean hasCustomName() {
        return !Strings.isNullOrEmpty((String)this.customName);
    }
}

