/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.text2speech.Narrator;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TipList;
import mcp.mobius.waila.cbcore.Layout;
import mcp.mobius.waila.client.KeyEvent;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="waila", value={Side.CLIENT})
public class WailaTickHandler {
    private static WailaTickHandler _instance;
    private static Narrator narrator;
    private static String lastNarration;
    public Tooltip tooltip = null;
    public MetaDataProvider handler = new MetaDataProvider();

    private WailaTickHandler() {
    }

    @SubscribeEvent
    public static void renderOverlay(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public static void tickClient(TickEvent.ClientTickEvent event) {
        if (!ConfigHandler.instance().showTooltip()) {
            return;
        }
        if (!Keyboard.isCreated()) {
            return;
        }
        if (!Keyboard.isKeyDown((int)KeyEvent.key_show.func_151463_i()) && !ConfigHandler.instance().getConfig("general", "waila.cfg.showmode", false) && ConfigHandler.instance().getConfig("general", "waila.cfg.show", false)) {
            ConfigHandler.instance().setConfig("general", "waila.cfg.show", false);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        WorldClient world = minecraft.field_71441_e;
        EntityPlayerSP player = minecraft.field_71439_g;
        if (world != null && player != null) {
            RayTracing.instance().fire();
            RayTraceResult target = RayTracing.instance().getTarget();
            TipList currentTip = new TipList();
            TipList currentTipHead = new TipList();
            TipList currentTipBody = new TipList();
            TipList currentTipTail = new TipList();
            if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
                DataAccessorCommon accessor = DataAccessorCommon.instance;
                accessor.set((World)world, (EntityPlayer)player, target);
                ItemStack targetStack = RayTracing.instance().getTargetStack();
                if (!targetStack.func_190926_b()) {
                    WailaTickHandler.instance().handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currentTipHead, Layout.HEADER);
                    WailaTickHandler.instance().handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currentTipBody, Layout.BODY);
                    WailaTickHandler.instance().handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currentTipTail, Layout.FOOTER);
                    if (ConfigHandler.instance().getConfig("general", "waila.cfg.shiftblock", false) && currentTipBody.size() > 0 && !accessor.getPlayer().func_70093_af()) {
                        currentTipBody.clear();
                        currentTipBody.add(TextFormatting.ITALIC + "Press shift for more data");
                    }
                    currentTip.addAll(currentTipHead);
                    currentTip.addAll(currentTipBody);
                    currentTip.addAll(currentTipTail);
                    WailaTickHandler.instance().tooltip = new Tooltip(currentTip, targetStack);
                }
            } else if (target != null && target.field_72313_a == RayTraceResult.Type.ENTITY) {
                DataAccessorCommon accessor = DataAccessorCommon.instance;
                accessor.set((World)world, (EntityPlayer)player, target);
                Entity targetEnt = RayTracing.instance().getTargetEntity();
                if (targetEnt != null) {
                    WailaTickHandler.instance().handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currentTipHead, Layout.HEADER);
                    WailaTickHandler.instance().handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currentTipBody, Layout.BODY);
                    WailaTickHandler.instance().handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currentTipTail, Layout.FOOTER);
                    if (ConfigHandler.instance().getConfig("general", "waila.cfg.shiftents", false) && currentTipBody.size() > 0 && !accessor.getPlayer().func_70093_af()) {
                        currentTipBody.clear();
                        currentTipBody.add(TextFormatting.ITALIC + "Press shift for more data");
                    }
                    currentTip.addAll(currentTipHead);
                    currentTip.addAll(currentTipBody);
                    currentTip.addAll(currentTipTail);
                    WailaTickHandler.instance().tooltip = new Tooltip(currentTip, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTooltip(WailaTooltipEvent event) {
        if (!ConfigHandler.instance().showTooltip()) {
            return;
        }
        if (!WailaTickHandler.getNarrator().active()) {
            return;
        }
        if (!ConfigHandler.instance().getConfig("general", "waila.cfg.tts", false)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        String narrate = TextFormatting.func_110646_a((String)event.getCurrentTip().get(0));
        if (lastNarration.equalsIgnoreCase(narrate)) {
            return;
        }
        if (event.getAccessor().getBlock() == Blocks.field_150350_a && event.getAccessor().getEntity() == null) {
            return;
        }
        WailaTickHandler.getNarrator().clear();
        WailaTickHandler.getNarrator().say(narrate);
        lastNarration = narrate;
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (_instance == null) {
            _instance = new WailaTickHandler();
        }
        return _instance;
    }

    static {
        lastNarration = "";
    }
}

