/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.util.TFCrafting;
import cofh.thermalinnovation.ThermalInnovation;
import cofh.thermalinnovation.item.ItemMultiPotion;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemInjector
extends ItemMultiPotion
implements IInitializer,
IBauble {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int CAPACITY_BASE = 2000;
    public static final int MB_PER_CYCLE = 50;
    public static final int MB_PER_USE = 250;
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static boolean enable = true;
    public static ItemStack injectorBasic;
    public static ItemStack injectorHardened;
    public static ItemStack injectorReinforced;
    public static ItemStack injectorSignalum;
    public static ItemStack injectorResonant;
    public static ItemStack injectorCreative;

    public ItemInjector() {
        super("thermalinnovation");
        this.func_77655_b("injector");
        this.func_77637_a(ThermalInnovation.tabTools);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalinnovation.injector.a.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalinnovation.injector.a.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalinnovation.injector.a.2"));
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalinnovation.injector.b." + this.getMode(stack)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null) {
            String color = fluid.getFluid().getRarity().field_77937_e.toString();
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName(fluid) + "\u00a77");
            if (ItemInjector.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)fluid.amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
            tooltip.add("");
            tooltip.add(StringHelper.localize((String)"info.thermalinnovation.injector.d"));
            ItemInjector.addPotionTooltip(fluid.tag, tooltip);
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemInjector.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)new ItemStack((Item)this, 1, metadata));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)new ItemStack((Item)this, 1, metadata));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ServerHelper.isClientWorld((World)world) || world.func_82737_E() % 32L != 0L) {
            return;
        }
        if (!(entity instanceof EntityLivingBase) || CoreUtils.isFakePlayer((Entity)entity) || this.getMode(stack) == 0) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.amount >= 50) {
            boolean used = false;
            for (PotionEffect effect : PotionUtils.func_185185_a((NBTTagCompound)fluid.tag)) {
                PotionEffect active = (PotionEffect)living.func_193076_bZ().get(effect.func_188419_a());
                if (active != null && active.func_76459_b() >= 40) continue;
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a(null, null, (EntityLivingBase)entity, effect.func_76458_c(), 0.5);
                } else {
                    PotionEffect potion = new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / 4, effect.func_76458_c(), effect.func_82720_e(), false);
                    living.func_70690_d(potion);
                }
                used = true;
            }
            if (used) {
                this.drain(stack, 50, true);
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.amount >= 250) {
            if (ServerHelper.isServerWorld((World)entity.field_70170_p)) {
                for (PotionEffect effect : PotionUtils.func_185185_a((NBTTagCompound)fluid.tag)) {
                    if (effect.func_188419_a().func_76403_b()) {
                        effect.func_188419_a().func_180793_a((Entity)player, (Entity)player, entity, effect.func_76458_c(), 0.5);
                        continue;
                    }
                    PotionEffect potion = new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / 2, effect.func_76458_c(), effect.func_82720_e(), true);
                    entity.func_70690_d(potion);
                }
                this.drain(stack, 250, true);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            FluidStack fluid;
            if (ServerHelper.isServerWorld((World)world) && (fluid = this.getFluid(stack)) != null && fluid.amount >= 250) {
                for (PotionEffect effect : PotionUtils.func_185185_a((NBTTagCompound)fluid.tag)) {
                    if (effect.func_188419_a().func_76403_b()) {
                        effect.func_188419_a().func_180793_a(null, null, (EntityLivingBase)player, effect.func_76458_c(), 1.0);
                        continue;
                    }
                    PotionEffect potion = new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), effect.func_82720_e(), false);
                    player.func_70690_d(potion);
                }
                this.drain(stack, 250, true);
            }
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    protected int getMaxFluidAmount(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemInjector.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    @Override
    public int colorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 2 && ColorHelper.hasColor0((ItemStack)stack)) {
            return ColorHelper.getColor0((ItemStack)stack);
        }
        return super.colorMultiplier(stack, tintIndex);
    }

    public int getMaxColorIndex(ItemStack stack) {
        return 1;
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        World world = player.field_70170_p;
        if (ServerHelper.isClientWorld((World)world) || world.func_82737_E() % 32L != 0L) {
            return;
        }
        if (CoreUtils.isFakePlayer((Entity)player) || this.getMode(stack) == 0) {
            return;
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.amount >= 50) {
            boolean used = false;
            for (PotionEffect effect : PotionUtils.func_185185_a((NBTTagCompound)fluid.tag)) {
                PotionEffect active = (PotionEffect)player.func_193076_bZ().get(effect.func_188419_a());
                if (active != null && active.func_76459_b() >= 40) continue;
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a(null, null, player, effect.func_76458_c(), 0.5);
                } else {
                    PotionEffect potion = new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / 4, effect.func_76458_c(), effect.func_82720_e(), false);
                    player.func_70690_d(potion);
                }
                used = true;
            }
            if (used) {
                this.drain(stack, 50, true);
            }
        }
    }

    public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (mode == 1) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187806_ee, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalinnovation.injector.c." + mode, new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,fill=%s,type=%s", ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0, MathHelper.clamp((int)(this.getFluidAmount(stack) > 0 ? 1 + this.getScaledFluidStored(stack, 7) : 0), (int)0, (int)7), ((TypeEntry)ItemInjector.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int color0 = 0; color0 < 2; ++color0) {
                for (int fill = 0; fill < 8; ++fill) {
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,fill=%s,type=%s", color0, fill, ((ItemMulti.ItemEntry)entry.getValue()).name))});
                }
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("injector"));
        ThermalInnovation.proxy.addIModelRegister((IModelRegister)this);
        ItemInjector.config();
        injectorBasic = this.addEntryItem(0, "standard0", CAPACITY[0], EnumRarity.COMMON);
        injectorHardened = this.addEntryItem(1, "standard1", CAPACITY[1], EnumRarity.COMMON);
        injectorReinforced = this.addEntryItem(2, "standard2", CAPACITY[2], EnumRarity.UNCOMMON);
        injectorSignalum = this.addEntryItem(3, "standard3", CAPACITY[3], EnumRarity.UNCOMMON);
        injectorResonant = this.addEntryItem(4, "standard4", CAPACITY[4], EnumRarity.RARE);
        injectorCreative = this.addEntryItem(32000, "creative", CAPACITY[4], EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)injectorBasic, (Object[])new Object[]{"BRB", "XBX", " I ", Character.valueOf('B'), Items.field_151069_bo, Character.valueOf('I'), "ingotSilver", Character.valueOf('R'), "dustGlowstone", Character.valueOf('X'), "ingotCopper"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)injectorHardened, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "nuggetCopper", Character.valueOf('X'), injectorBasic});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)injectorReinforced, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "nuggetInvar", Character.valueOf('X'), injectorHardened});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)injectorSignalum, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "nuggetElectrum", Character.valueOf('X'), injectorReinforced});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)injectorResonant, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "nuggetSignalum", Character.valueOf('X'), injectorSignalum});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorBasic, (Object[])new Object[]{injectorBasic, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorHardened, (Object[])new Object[]{injectorHardened, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorReinforced, (Object[])new Object[]{injectorReinforced, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorSignalum, (Object[])new Object[]{injectorSignalum, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorResonant, (Object[])new Object[]{injectorResonant, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)injectorCreative, (Object[])new Object[]{injectorCreative, "cofh:potion"});
        RecipeHelper.addColorRecipe((ItemStack)injectorBasic, (Object[])new Object[]{injectorBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)injectorHardened, (Object[])new Object[]{injectorHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)injectorReinforced, (Object[])new Object[]{injectorReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)injectorSignalum, (Object[])new Object[]{injectorSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)injectorResonant, (Object[])new Object[]{injectorResonant, "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)injectorBasic, (Object[])new Object[]{injectorBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)injectorHardened, (Object[])new Object[]{injectorHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)injectorReinforced, (Object[])new Object[]{injectorReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)injectorSignalum, (Object[])new Object[]{injectorSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)injectorResonant, (Object[])new Object[]{injectorResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Injector";
        enable = ThermalInnovation.CONFIG.get(category, "Enable", true);
        int capacity = 2000;
        String comment = "Adjust this value to change the amount of Fluid (in mB) stored by a Basic Hypoinfuser. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    private void addEntry(int metadata, String name, int capacity) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity));
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;

        TypeEntry(String name, int capacity) {
            this.name = name;
            this.capacity = capacity;
        }
    }
}

