/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.ListUtils;
import bspkrs.util.ModulusBlockID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeRegistry {
    private Map<String, TreeDefinition> treeDefs;
    private Map<BlockID, String> logToStringMap;
    private TreeDefinition masterDefinition;
    private Map<String, TreeDefinition> vanTrees;
    private List<BlockID> blacklist;
    private Set<BlockPos> blocksBeingChopped;
    private static TreeRegistry instance;

    public static TreeRegistry instance() {
        if (instance == null) {
            new TreeRegistry();
        }
        return instance;
    }

    protected TreeRegistry() {
        instance = this;
        this.initMapsAndLists();
        this.initVanillaTreeDefs();
    }

    protected void initMapsAndLists() {
        this.treeDefs = new HashMap<String, TreeDefinition>();
        this.logToStringMap = new HashMap<BlockID, String>();
        this.masterDefinition = new TreeDefinition();
        this.blocksBeingChopped = new HashSet<BlockPos>();
        this.readBlacklistFromDelimitedString(TCSettings.blockIDBlacklist);
    }

    protected void initVanillaTreeDefs() {
        this.vanTrees = new TreeMap<String, TreeDefinition>();
        this.vanTrees.put("vanilla_oak", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150364_r, 0, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150362_t, 0, 8)));
        this.vanTrees.put("vanilla_spruce", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150364_r, 1, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150362_t, 1, 8)));
        this.vanTrees.put("vanilla_birch", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150364_r, 2, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150362_t, 2, 8)));
        this.vanTrees.put("vanilla_jungle", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150364_r, 3, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150362_t, 3, 8)).addLeafID(new ModulusBlockID((Block)Blocks.field_150362_t, 0, 8)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_acacia", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150363_s, 0, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150361_u, 0, 8)));
        this.vanTrees.put("vanilla_dark_oak", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150363_s, 1, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150361_u, 1, 8)));
        this.vanTrees.put("vanilla_future_tree_1", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150363_s, 2, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150361_u, 2, 8)));
        this.vanTrees.put("vanilla_future_tree_2", new TreeDefinition().addLogID(new ModulusBlockID(Blocks.field_150363_s, 3, 4)).addLeafID(new ModulusBlockID((Block)Blocks.field_150361_u, 3, 8)));
        this.vanTrees.put("vanilla_huge_brown_mushroom", new TreeDefinition().addLogID(new BlockID(Blocks.field_150420_aW, 10)).addLogID(new BlockID(Blocks.field_150420_aW, 15)).addLeafID(new BlockID(Blocks.field_150420_aW, 1)).addLeafID(new BlockID(Blocks.field_150420_aW, 2)).addLeafID(new BlockID(Blocks.field_150420_aW, 3)).addLeafID(new BlockID(Blocks.field_150420_aW, 4)).addLeafID(new BlockID(Blocks.field_150420_aW, 5)).addLeafID(new BlockID(Blocks.field_150420_aW, 6)).addLeafID(new BlockID(Blocks.field_150420_aW, 7)).addLeafID(new BlockID(Blocks.field_150420_aW, 8)).addLeafID(new BlockID(Blocks.field_150420_aW, 9)).addLeafID(new BlockID(Blocks.field_150420_aW, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_red_mushroom", new TreeDefinition().addLogID(new BlockID(Blocks.field_150419_aX, 10)).addLogID(new BlockID(Blocks.field_150419_aX, 15)).addLeafID(new BlockID(Blocks.field_150419_aX, 1)).addLeafID(new BlockID(Blocks.field_150419_aX, 2)).addLeafID(new BlockID(Blocks.field_150419_aX, 3)).addLeafID(new BlockID(Blocks.field_150419_aX, 4)).addLeafID(new BlockID(Blocks.field_150419_aX, 5)).addLeafID(new BlockID(Blocks.field_150419_aX, 6)).addLeafID(new BlockID(Blocks.field_150419_aX, 7)).addLeafID(new BlockID(Blocks.field_150419_aX, 8)).addLeafID(new BlockID(Blocks.field_150419_aX, 9)).addLeafID(new BlockID(Blocks.field_150419_aX, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
    }

    protected void registerVanillaTreeDefs() {
        for (Map.Entry<String, TreeDefinition> e : this.vanTrees.entrySet()) {
            this.registerTree(e.getKey(), e.getValue());
        }
    }

    public synchronized void registerTree(String newKey, TreeDefinition newTD) {
        if (newTD != null) {
            LinkedList<String> sharedLogTrees = new LinkedList<String>();
            HashMap<BlockID, String> toAdd = new HashMap<BlockID, String>();
            for (BlockID blockID : newTD.getLogList()) {
                if (!this.isRegistered(blockID) && !this.blacklist.contains(blockID)) {
                    toAdd.put(blockID, newKey);
                    continue;
                }
                if (!this.logToStringMap.containsKey(blockID) || sharedLogTrees.contains(this.logToStringMap.get(blockID))) continue;
                sharedLogTrees.add(this.logToStringMap.get(blockID));
            }
            if (!newKey.trim().isEmpty() && !this.isRegistered(newKey) && sharedLogTrees.size() == 0) {
                TCLog.debug("Tree Definition \"%s\" is new.  Proceeding to insert new key.", newKey);
                this.treeDefs.put(newKey, newTD);
                TCLog.debug("    New key %s added with values: %s", newKey, newTD.toString());
                this.logToStringMap.putAll(toAdd);
            } else if (!newKey.trim().isEmpty()) {
                if (sharedLogTrees.size() > 0) {
                    for (String existingKey : sharedLogTrees) {
                        TCLog.debug("Tree Definition \"%s\" contains a log that is registered with an existing tree (%s).  The existing definition will be merged with the new tree.", newKey, existingKey);
                        newTD.appendWithSettings(this.treeDefs.remove(existingKey));
                    }
                    this.treeDefs.put(newKey, newTD);
                    TCLog.debug("    New key %s added with values: %s", newKey, newTD.toString());
                    for (BlockID blockID : newTD.getLogList()) {
                        this.logToStringMap.put(blockID, newKey);
                    }
                } else {
                    TCLog.debug("\"%s\" is already registered.  The new definition will be appended to the existing entry.", newKey);
                    this.treeDefs.get(newKey).appendWithSettings(newTD);
                    TCLog.debug("    Key %s appended with values: %s", newKey, newTD.toString());
                    this.logToStringMap.putAll(toAdd);
                }
            } else if (sharedLogTrees.size() == 1) {
                String existingTree = (String)sharedLogTrees.remove(0);
                this.treeDefs.get(existingTree).appendWithSettings(newTD);
                TCLog.debug("    Blank key tree appended with values: %s", newTD.toString());
                for (BlockID log : newTD.getLogList()) {
                    if (this.logToStringMap.containsKey(log)) continue;
                    this.logToStringMap.put(log, existingTree);
                }
                this.masterDefinition.append(newTD);
            } else {
                TCLog.warning("TreeDefinition cannot be registered with an empty Key.", new Object[0]);
                return;
            }
            if (!newKey.trim().isEmpty()) {
                this.masterDefinition.append(this.treeDefs.get(newKey));
            }
        } else {
            TCLog.warning("TreeDefinition cannot be null when registering a tree!", new Object[0]);
        }
    }

    public boolean trackTreeChopEventAt(BlockPos c) {
        if (!this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.add(c);
            return true;
        }
        return false;
    }

    public void endTreeChopEventAt(BlockPos c) {
        if (this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.remove(c);
        }
    }

    public TreeDefinition masterDefinition() {
        return this.masterDefinition;
    }

    public boolean isRegistered(String key) {
        return this.treeDefs.containsKey(key);
    }

    public boolean isRegistered(BlockID log) {
        if (!this.blacklist.contains(log)) {
            return this.masterDefinition.isLogBlock(log);
        }
        return false;
    }

    public TreeDefinition get(String key) {
        if (this.isRegistered(key)) {
            return this.treeDefs.get(key);
        }
        return null;
    }

    public TreeDefinition get(BlockID blockID) {
        if (this.isRegistered(blockID)) {
            if (TCSettings.useStrictBlockPairing) {
                String treeKey = this.logToStringMap.get(blockID);
                TreeDefinition treeDef = this.get(this.logToStringMap.get(blockID));
                if (treeDef != null) {
                    return treeDef;
                }
                if (blockID.metadata > -1) {
                    treeKey = this.logToStringMap.get(new BlockID(blockID.id));
                    return this.get(treeKey);
                }
            }
            return this.masterDefinition;
        }
        return null;
    }

    public static boolean canAutoDetect(World world, Block block, BlockPos pos) {
        return block.isWood((IBlockAccess)world, pos) || block.canSustainLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos);
    }

    public static synchronized TreeDefinition autoDetectTree(World world, BlockID blockID, BlockPos blockPos, boolean shouldLog) {
        TreeDefinition treeDef = instance.get(blockID);
        List<BlockID> leaves = Treecapitator.getLeavesForTree(world, blockID, blockPos, treeDef == null);
        if (treeDef == null && leaves.size() >= TCSettings.minLeavesToID) {
            treeDef = new TreeDefinition().addLogID(blockID).addAllLeafIDs(leaves);
            int index = blockID.id.indexOf(":");
            String modID = index == -1 ? "minecraft" : blockID.id.substring(0, index);
            String treeName = blockID.id + "_" + blockID.metadata;
            treeName = treeName.replaceAll("\\.", "_").replaceAll(":", "_").trim().replaceAll(" ", "_");
            instance.registerTree(treeName, treeDef);
            ModConfigRegistry.instance().appendTreeToModConfig(modID, treeName, treeDef);
            if (shouldLog) {
                TCLog.debug("Auto Tree Detection: New tree added: %s (%s)", treeName, treeDef);
            }
        } else if (treeDef != null && leaves.size() >= TCSettings.minLeavesToID) {
            if (!ListUtils.doesListAContainAllUniqueListBValues(treeDef.leafBlocks, leaves)) {
                treeDef.addAllLeafIDs(leaves);
                if (shouldLog) {
                    TCLog.debug("Auto Tree Detection: Existing tree \"%s\" updated with new leaves: %s", TreeRegistry.instance.logToStringMap.get(blockID), ListUtils.getListAsUniqueDelimitedString(leaves, "; "));
                }
            }
        } else {
            treeDef = null;
        }
        return treeDef;
    }

    public List<BlockID> masterLogList() {
        return this.masterDefinition.getLogList();
    }

    public List<BlockID> masterLeafList() {
        return this.masterDefinition.getLeafList();
    }

    public Map<String, TreeDefinition> vanillaTrees() {
        return new TreeMap<String, TreeDefinition>(this.vanTrees);
    }

    public List<BlockID> blacklist() {
        return new ArrayList<BlockID>(this.blacklist);
    }

    public void readBlacklistFromDelimitedString(String dList) {
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList(dList, ";");
    }

    protected void readFromNBT(NBTTagCompound ntc) {
        int i;
        this.treeDefs = new HashMap<String, TreeDefinition>();
        NBTTagList l = ntc.func_150295_c("treeDefs", 10);
        for (i = 0; i < l.func_74745_c(); ++i) {
            NBTTagCompound treeNBT = l.func_150305_b(i);
            this.treeDefs.put(treeNBT.func_74779_i("treeName"), new TreeDefinition(treeNBT));
        }
        this.logToStringMap = new HashMap<BlockID, String>();
        l = ntc.func_150295_c("logToStringMap", 8);
        for (i = 0; i < l.func_74745_c(); ++i) {
            String s = l.func_150307_f(i);
            String[] t = s.split("=");
            this.logToStringMap.put(BlockID.parse(t[0]), t[1]);
        }
        this.masterDefinition = new TreeDefinition(ntc.func_74775_l("masterDefinition"));
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList(ntc.func_74779_i("blacklist"), ";");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        NBTTagList trees = new NBTTagList();
        for (Map.Entry<String, TreeDefinition> entry : this.treeDefs.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(nBTTagCompound);
            nBTTagCompound.func_74778_a("treeName", entry.getKey());
            trees.func_74742_a((NBTBase)nBTTagCompound);
        }
        ntc.func_74782_a("treeDefs", (NBTBase)trees);
        NBTTagList entries = new NBTTagList();
        for (Map.Entry<BlockID, String> entry : this.logToStringMap.entrySet()) {
            NBTTagString s = new NBTTagString(entry.getKey() + "=" + entry.getValue());
            entries.func_74742_a((NBTBase)s);
        }
        ntc.func_74782_a("logToStringMap", (NBTBase)entries);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.masterDefinition.writeToNBT(nBTTagCompound);
        ntc.func_74782_a("masterDefinition", (NBTBase)nBTTagCompound);
        ntc.func_74778_a("blacklist", ListUtils.getListAsDelimitedString(this.blacklist, ";"));
    }
}

