/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.gamestages;

import com.therandomlabs.vanilladeathchest.VanillaDeathChest;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class VDCStageInfo {
    public static final Map<String, VDCStageInfo> STAGES = new LinkedHashMap<String, VDCStageInfo>();
    private static final IForgeRegistry<Item> ITEM_REGISTRY = GameRegistry.findRegistry(Item.class);
    private boolean damageUnlockerSet;
    private boolean damageUnlockerInsteadOfConsume;
    private String defenseEntityNBT;
    private String defenseEntityRegistryName;
    private int defenseEntitySpawnCount;
    private int unlockerConsumeAmount = Integer.MAX_VALUE;
    private int unlockerMeta = -1;
    private String unlockerRegistryName;
    private String unlockFailedMessage;
    private ResourceLocation defenseEntity;
    private Item unlocker;
    private String chatMessage;
    private String containerDisplayName;
    private String registryNameRegex;
    private boolean useContainerInInventorySet;
    private boolean useContainerInInventory;

    public boolean damageUnlockerInsteadOfConsume() {
        return this.damageUnlockerSet ? this.damageUnlockerInsteadOfConsume : VDCConfig.Defense.damageUnlockerInsteadOfConsume;
    }

    public void setDamageUnlockerInsteadOfConsume(boolean flag) {
        this.damageUnlockerSet = true;
        this.damageUnlockerInsteadOfConsume = flag;
    }

    public String getDefenseEntityNBT() {
        return this.defenseEntityNBT == null ? VDCConfig.Defense.defenseEntityNBT : this.defenseEntityNBT;
    }

    public void setDefenseEntityNBT(String nbt) {
        try {
            JsonToNBT.func_180713_a((String)nbt);
            this.defenseEntityNBT = nbt;
        }
        catch (NBTException ex) {
            this.defenseEntityNBT = "{}";
        }
    }

    public String getDefenseEntityRegistryName() {
        return this.defenseEntityRegistryName == null ? VDCConfig.Defense.defenseEntityRegistryName : this.defenseEntityRegistryName;
    }

    public void setDefenseEntityRegistryName(String registryName) {
        Object[] entityNames = EntityList.func_180124_b().toArray(new ResourceLocation[0]);
        int index = ArrayUtils.indexOf((Object[])entityNames, (Object)new ResourceLocation(registryName));
        if (index == -1) {
            this.defenseEntity = null;
            this.defenseEntityRegistryName = "";
        } else {
            this.defenseEntity = entityNames[index];
            this.defenseEntityRegistryName = this.defenseEntity.toString();
        }
    }

    public int getDefenseEntitySpawnCount() {
        return this.defenseEntitySpawnCount == 0 ? VDCConfig.Defense.defenseEntitySpawnCount : this.defenseEntitySpawnCount;
    }

    public void setDefenseEntitySpawnCount(int count) {
        this.defenseEntitySpawnCount = Math.max(count, 1);
    }

    public ResourceLocation getDefenseEntity() {
        return this.defenseEntity == null ? VDCConfig.Defense.defenseEntity : this.defenseEntity;
    }

    public int getUnlockerConsumeAmount() {
        return this.unlockerConsumeAmount == Integer.MAX_VALUE ? VDCConfig.Defense.unlockerConsumeAmount : this.unlockerConsumeAmount;
    }

    public void setUnlockerConsumeAmount(int amount) {
        this.unlockerConsumeAmount = MathHelper.func_76125_a((int)amount, (int)0, (int)Short.MAX_VALUE);
    }

    public int getUnlockerMeta() {
        return this.unlockerMeta == -1 ? VDCConfig.Defense.unlockerMeta : this.unlockerMeta;
    }

    public void setUnlockerMeta(int meta) {
        this.unlockerMeta = MathHelper.func_76125_a((int)meta, (int)0, (int)Short.MAX_VALUE);
    }

    public String getUnlockerRegistryName() {
        return this.unlockerRegistryName == null ? VDCConfig.Defense.unlocker.getRegistryName().toString() : this.unlockerRegistryName;
    }

    public void setUnlockerRegistryName(String registryName) {
        this.unlocker = (Item)ITEM_REGISTRY.getValue(new ResourceLocation(registryName));
        if (this.unlocker != null) {
            if (this.unlocker == Items.field_190931_a) {
                this.unlocker = null;
                this.unlockerRegistryName = "";
            } else {
                this.unlockerRegistryName = this.unlocker.getRegistryName().toString();
            }
        }
    }

    public Item getUnlocker() {
        return this.unlocker == null ? VDCConfig.Defense.unlocker : this.unlocker;
    }

    public String getUnlockFailedMessage() {
        return this.unlockFailedMessage == null ? VDCConfig.Defense.unlockFailedMessage : this.unlockFailedMessage;
    }

    public void setUnlockFailedMessage(String message) {
        this.unlockFailedMessage = message;
    }

    public String getChatMessage() {
        return this.chatMessage == null ? VDCConfig.Spawning.chatMessage : this.chatMessage;
    }

    public void setChatMessage(String message) {
        this.chatMessage = message;
    }

    public String getContainerDisplayName() {
        return this.containerDisplayName == null ? VDCConfig.Spawning.containerDisplayName : this.containerDisplayName;
    }

    public void setContainerDisplayName(String name) {
        this.containerDisplayName = name;
    }

    public String getRegistryNameRegex() {
        return this.registryNameRegex == null ? VDCConfig.Spawning.registryNameRegex : this.registryNameRegex;
    }

    public void setRegistryNameRegex(String regex) {
        this.registryNameRegex = regex;
    }

    public boolean useContainerInInventory() {
        return this.useContainerInInventorySet ? this.useContainerInInventory : VDCConfig.Spawning.useContainerInInventory;
    }

    public void setUseContainerInInventory(boolean flag) {
        this.useContainerInInventory = flag;
        this.useContainerInInventorySet = true;
    }

    public static VDCStageInfo get(EntityPlayer player) {
        if (!VanillaDeathChest.GAME_STAGES_LOADED) {
            return new VDCStageInfo();
        }
        VDCStageInfo info = null;
        for (Map.Entry<String, VDCStageInfo> entry : STAGES.entrySet()) {
            if (!GameStageHelper.hasStage((EntityPlayer)player, (String)entry.getKey())) continue;
            info = entry.getValue();
        }
        return info == null ? new VDCStageInfo() : info;
    }
}

