/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestManager;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.world.storage.VDCSavedData;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="vanilladeathchest")
public final class DeathChestContentsChecker {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!VDCConfig.Misc.deathChestsDisappearWhenEmptied) {
            return;
        }
        VDCSavedData savedData = VDCSavedData.get(event.world);
        IChunkProvider provider = event.world.func_72863_F();
        for (Map.Entry<BlockPos, DeathChest> entry : savedData.getDeathChests().entrySet()) {
            TileEntity tileEntity;
            BlockPos pos = entry.getKey();
            Chunk chunk = provider.func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (chunk == null || chunk.func_76621_g() || !((tileEntity = event.world.func_175625_s(pos)) instanceof TileEntityLockableLoot)) continue;
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
            boolean empty = true;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
                empty = false;
                break;
            }
            if (!empty || DeathChestManager.removeDeathChest(event.world, pos) == null) continue;
            event.world.func_175698_g(entry.getValue().getPos());
            if (!entry.getValue().isDoubleChest()) continue;
            event.world.func_175698_g(entry.getValue().getPos().func_177974_f());
        }
    }
}

