/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.therandomlabs.vanilladeathchest.api.event.DeathChestRemoveEvent;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="vanilladeathchest")
public final class DeathChestDropHandler {
    private static final Map<BlockPos, Block> justRemoved = new HashMap<BlockPos, Block>();

    @SubscribeEvent
    public static void onDeathChestRemove(DeathChestRemoveEvent event) {
        if (VDCConfig.Misc.dropDeathChests) {
            return;
        }
        BlockPos west = event.getWest();
        BlockPos east = event.getEast();
        if (west != null) {
            justRemoved.put(west, event.getChest().getWorld().func_180495_p(west).func_177230_c());
        }
        if (east != null) {
            justRemoved.put(east, event.getChest().getWorld().func_180495_p(east).func_177230_c());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        boolean isChest;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityItem)) {
            return;
        }
        ItemStack stack = ((EntityItem)entity).func_92059_d();
        if (stack.func_190916_E() != 1) {
            return;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        boolean bl = isChest = block == Blocks.field_150486_ae;
        if (!isChest && !(block instanceof BlockShulkerBox)) {
            return;
        }
        Vec3d pos = event.getEntity().func_174791_d();
        for (Map.Entry<BlockPos, Block> entry : justRemoved.entrySet()) {
            BlockPos chestPos;
            if (block != entry.getValue() || !(pos.func_186679_c((double)(chestPos = entry.getKey()).func_177958_n(), (double)chestPos.func_177956_o(), (double)chestPos.func_177952_p()) <= 1.6875)) continue;
            if (!isChest) {
                NonNullList inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((NBTTagCompound)stack.func_77978_p().func_74775_l("BlockEntityTag"), (NonNullList)inventory);
                for (ItemStack drop : inventory) {
                    if (drop.func_190926_b()) continue;
                    Block.func_180635_a((World)world, (BlockPos)chestPos, (ItemStack)drop);
                }
            }
            event.setCanceled(true);
            justRemoved.remove(chestPos);
            break;
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            justRemoved.clear();
        }
    }
}

