/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.IModelBaker;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDecorativeLeaves
extends ModelBlockCached<BlockDecorativeLeaves, Key> {
    public ModelDecorativeLeaves() {
        super(BlockDecorativeLeaves.class);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)(block instanceof BlockDecorativeLeaves), (Object)"ItemStack must be for decorative leaves.");
        BlockDecorativeLeaves bBlock = (BlockDecorativeLeaves)block;
        return new Key(bBlock.getTreeType(stack.func_77960_j()), Proxies.render.fancyGraphicsEnabled());
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        Block block = state.func_177230_c();
        Preconditions.checkArgument((boolean)(block instanceof BlockDecorativeLeaves), (Object)"state must be for decorative leaves.");
        BlockDecorativeLeaves bBlock = (BlockDecorativeLeaves)block;
        return new Key((TreeDefinition)((Object)state.func_177229_b((IProperty)bBlock.getVariant())), Proxies.render.fancyGraphicsEnabled());
    }

    @Override
    protected void bakeBlock(BlockDecorativeLeaves block, Key key, IModelBaker baker, boolean inventory) {
        TreeDefinition treeDefinition = key.definition;
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        ITreeGenome genome = treeDefinition.getGenome();
        IAlleleTreeSpecies species = genome.getPrimary();
        ILeafSpriteProvider leafSpriteProvider = species.getLeafSpriteProvider();
        ResourceLocation leafSpriteLocation = leafSpriteProvider.getSprite(false, key.fancy);
        TextureAtlasSprite leafSprite = map.func_110572_b(leafSpriteLocation.toString());
        baker.addBlockModel(null, leafSprite, 0);
        ResourceLocation fruitSpriteLocation = genome.getFruitProvider().getDecorativeSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel(null, fruitSprite, 2);
        }
        baker.setParticleSprite(leafSprite);
    }

    @Override
    protected IBakedModel bakeModel(IBlockState state, Key key, BlockDecorativeLeaves block) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, key, (IModelBaker)baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    public static class Key {
        public final TreeDefinition definition;
        public final boolean fancy;
        private final int hashCode;

        public Key(TreeDefinition definition, boolean fancy) {
            this.definition = definition;
            this.fancy = fancy;
            this.hashCode = Objects.hash(definition, fancy);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.definition == this.definition && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

