/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class WoodTexture {
    private WoodTexture() {
    }

    abstract ImmutableMap<String, String> getLocations(String var1);

    static class TextureMap
    extends WoodTexture {
        private final ImmutableMap<String, SimpleTexture> textures;

        public TextureMap(ImmutableMap<String, SimpleTexture> textures) {
            this.textures = textures;
        }

        @Override
        ImmutableMap<String, String> getLocations(String kindName) {
            SimpleTexture texture = (SimpleTexture)this.textures.get((Object)kindName);
            if (texture == null) {
                return ImmutableMap.of();
            }
            return texture.getLocations(kindName);
        }
    }

    static class SimpleTexture
    extends WoodTexture {
        private final ImmutableMap<String, String> locations;

        public SimpleTexture(ImmutableMap<String, String> locations) {
            this.locations = locations;
        }

        @Override
        ImmutableMap<String, String> getLocations(String kindName) {
            return this.locations;
        }
    }
}

