/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Preconditions;
import forestry.Forestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkUtil {
    public static <P extends IForestryPacketClient> void sendNetworkPacket(P packet, BlockPos pos, World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerChunkMap playerManager = worldServer.func_184164_w();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        for (Object playerObj : world.field_73010_i) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.func_72694_a(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            NetworkUtil.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    public static void sendToPlayer(IForestryPacketClient packet, EntityPlayer entityplayer) {
        if (!(entityplayer instanceof EntityPlayerMP) || entityplayer instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        Forestry.getPacketHandler().sendPacket(packet.getPacket(), player);
    }

    public static void inventoryChangeNotify(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(IForestryPacketServer packet) {
        NetHandlerPlayClient netHandler = Minecraft.func_71410_x().func_147114_u();
        Preconditions.checkNotNull((Object)netHandler, (Object)"Tried to send packet before netHandler (client world) exists.");
        netHandler.func_147297_a((Packet)packet.getPacket());
    }
}

