/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.registry.recipe.ArbitraryCrusherRecipe;
import com.mcmoddev.lib.registry.recipe.OreDictionaryCrusherRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class BaseMetalsIntegration
extends AbstractIntegrationThread {
    BaseMetalsIntegration() {
        super("Base Metals");
    }

    public String call() {
        try {
            this.fixCrushingRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Fixing Everything!";
    }

    private void fixCrushingRecipes() {
        ArrayList recipesToRemove = new ArrayList();
        ArrayList newRecipes = new ArrayList();
        CrusherRecipeRegistry.getAll().forEach(recipe -> {
            ItemStack newOutput;
            ItemStack output = recipe.getOutput();
            if (output != (newOutput = this.resourceHandler.getMainItemStack(recipe.getOutput()))) {
                recipesToRemove.add(recipe.getRegistryName());
                if (recipe instanceof ArbitraryCrusherRecipe) {
                    newRecipes.add(new ArbitraryCrusherRecipe((ItemStack)recipe.getInputs().get(0), newOutput));
                } else if (recipe instanceof OreDictionaryCrusherRecipe) {
                    newRecipes.add(new OreDictionaryCrusherRecipe((String)Util.getField(OreDictionaryCrusherRecipe.class, (String)"oreDictSource", (Object)recipe, String.class), newOutput));
                }
            }
        });
        CrusherRecipeRegistry crusherRecipeRegistry = CrusherRecipeRegistry.getInstance();
        recipesToRemove.forEach(arg_0 -> ((CrusherRecipeRegistry)crusherRecipeRegistry).remove(arg_0));
        newRecipes.forEach(arg_0 -> ((CrusherRecipeRegistry)crusherRecipeRegistry).register(arg_0));
    }
}

