/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.plugin.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.oredict.MCOreDictEntry;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.UniDict;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.plugin.crafttweaker.removalByKind.Crafting;
import wanion.unidict.plugin.crafttweaker.removalByKind.Furnace;
import wanion.unidict.plugin.crafttweaker.removalByKind.RemovalByKind;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniResourceContainer;

@ZenRegister
@ZenClass(value="mods.unidict.api")
public final class UniDictCraftTweakerPlugin {
    private static final List<ShapedRecipeTemplate> NEW_SHAPED_RECIPE_TEMPLATE_LIST = new ArrayList<ShapedRecipeTemplate>();
    private static final List<ShapelessRecipeTemplate> NEW_SHAPELESS_RECIPE_TEMPLATE_LIST = new ArrayList<ShapelessRecipeTemplate>();
    private static final Map<Class<? extends RemovalByKind>, RemovalByKind> REMOVAL_BY_KIND_MAP = new HashMap<Class<? extends RemovalByKind>, RemovalByKind>();
    public static final Map<String, RemovalByKind> NAME_REMOVAL_BY_KIND_MAP = new HashMap<String, RemovalByKind>();

    private UniDictCraftTweakerPlugin() {
    }

    @ZenMethod
    public static void newShapedRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull Object[][] inputs) {
        CraftTweakerAPI.apply((IAction)new ShapedRecipeTemplate(outputKind, outputSize, inputs));
    }

    @ZenMethod
    public static void newShapelessRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull Object[] inputs) {
        CraftTweakerAPI.apply((IAction)new ShapelessRecipeTemplate(outputKind, outputSize, inputs));
    }

    public static void preInit() {
        UniDictCraftTweakerPlugin.registerAbstractRemovalByKind(new Crafting());
        UniDictCraftTweakerPlugin.registerAbstractRemovalByKind(new Furnace());
    }

    private static void registerAbstractRemovalByKind(@Nonnull RemovalByKind removalByKind) {
        REMOVAL_BY_KIND_MAP.put(removalByKind.getClass(), removalByKind);
        NAME_REMOVAL_BY_KIND_MAP.put(removalByKind.toString(), removalByKind);
    }

    public static <R extends RemovalByKind> R getRemovalByKind(@Nonnull Class<R> abstractRemovalByKindClass) {
        return (R)((RemovalByKind)abstractRemovalByKindClass.cast(REMOVAL_BY_KIND_MAP.get(abstractRemovalByKindClass)));
    }

    public static void init() {
        UniDictAPI uniDictAPI;
        UniDictAPI uniDictAPI2 = uniDictAPI = REMOVAL_BY_KIND_MAP.size() > 0 || NEW_SHAPED_RECIPE_TEMPLATE_LIST.size() > 0 || NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.size() > 0 ? UniDict.getAPI() : null;
        if (uniDictAPI == null) {
            return;
        }
        REMOVAL_BY_KIND_MAP.values().forEach(removalByKind -> removalByKind.apply(uniDictAPI));
        ArrayList<IRecipe> recipeList = new ArrayList<IRecipe>();
        UniDictCraftTweakerPlugin.fetchShapedRecipeTemplates(uniDictAPI, recipeList);
        UniDictCraftTweakerPlugin.fetchShapelessRecipeTemplates(uniDictAPI, recipeList);
        IForgeRegistry recipeRegistry = ForgeRegistries.RECIPES;
        recipeList.forEach(recipe -> recipeRegistry.register((IForgeRegistryEntry)recipe.setRegistryName(new ResourceLocation(recipe.func_193358_e()))));
    }

    private static void fetchShapedRecipeTemplates(@Nonnull UniDictAPI uniDictAPI, @Nonnull List<IRecipe> recipeList) {
        NEW_SHAPED_RECIPE_TEMPLATE_LIST.forEach(shapedRecipeTemplate -> {
            int n;
            boolean badEntry = false;
            if (Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind) == 0) {
                badEntry = true;
            }
            Object[][] objectArray = ((ShapedRecipeTemplate)shapedRecipeTemplate).inputs;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object[] subInputs;
                for (Object input : subInputs = objectArray[n]) {
                    if (input == null || !(input instanceof String) || ((String)input).isEmpty() || !((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind.equals(input) && Resource.getKindFromName((String)input) != 0) continue;
                    badEntry = true;
                }
            }
            if (!badEntry) {
                TObjectIntHashMap nameKindMap = new TObjectIntHashMap();
                Object[][] objectArray2 = ((ShapedRecipeTemplate)shapedRecipeTemplate).inputs;
                n = objectArray2.length;
                for (int subInputs = 0; subInputs < n; ++subInputs) {
                    Object[] subInputs2;
                    for (Object input : subInputs2 = objectArray2[subInputs]) {
                        if (!(input instanceof String) || nameKindMap.containsKey(input)) continue;
                        nameKindMap.put((Object)((String)input), Resource.getKindFromName((String)input));
                    }
                }
                nameKindMap.put((Object)((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind, Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind));
                Object[] trueInputs = new Object[9];
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        Object input = ((ShapedRecipeTemplate)shapedRecipeTemplate).inputs[y][x];
                        if (input instanceof String && !input.equals("")) {
                            trueInputs[y * 3 + x] = input;
                            continue;
                        }
                        if (input instanceof MCItemStack && ((MCItemStack)input).getInternal() instanceof ItemStack) {
                            trueInputs[y * 3 + x] = ((MCItemStack)input).getInternal();
                            continue;
                        }
                        if (!(input instanceof MCOreDictEntry)) continue;
                        trueInputs[y * 3 + x] = ((MCOreDictEntry)input).getName();
                    }
                }
                RecipeAttributes recipeAttributes = RecipeHelper.rawShapeToShape((Object[])trueInputs);
                int outputKind = Resource.getKindFromName(((ShapedRecipeTemplate)shapedRecipeTemplate).outputKind);
                List<Resource> resourceList = uniDictAPI.getResources(nameKindMap.values());
                resourceList.forEach(resource -> {
                    UniResourceContainer uniResourceContainer = resource.getChild(outputKind);
                    ItemStack itemStack = uniResourceContainer.getMainEntry();
                    int stackSize = MathHelper.func_76125_a((int)((ShapedRecipeTemplate)shapedRecipeTemplate).outputSize, (int)1, (int)itemStack.func_77976_d());
                    itemStack.func_190920_e(stackSize);
                    recipeList.add((IRecipe)new ShapedOreRecipe(new ResourceLocation("unidict", uniResourceContainer.name + ".x" + stackSize + "_shape." + recipeAttributes.shape + ".template"), itemStack, UniDictCraftTweakerPlugin.kindShapeToActualShape(recipeAttributes.actualShape, resource)));
                });
            }
        });
    }

    private static void fetchShapelessRecipeTemplates(@Nonnull UniDictAPI uniDictAPI, @Nonnull List<IRecipe> recipeList) {
        NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.forEach(shapelessRecipeTemplate -> {
            boolean badEntry = false;
            if (Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind) == 0) {
                badEntry = true;
            }
            for (Object input : ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs) {
                if (!(input instanceof String) || ((String)input).isEmpty() || !((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind.equals(input) && Resource.getKindFromName((String)input) != 0) continue;
                badEntry = true;
            }
            if (!badEntry) {
                TObjectIntHashMap nameKindMap = new TObjectIntHashMap();
                nameKindMap.put((Object)((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind, Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind));
                for (Object input : ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs) {
                    if (!(input instanceof String) || nameKindMap.containsKey(input)) continue;
                    nameKindMap.put((Object)((String)input), Resource.getKindFromName((String)input));
                }
                int outputKind = Resource.getKindFromName(((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputKind);
                List<Resource> resourceList = uniDictAPI.getResources(nameKindMap.values());
                resourceList.forEach(resource -> {
                    UniResourceContainer uniResourceContainer = resource.getChild(outputKind);
                    ItemStack itemStack = uniResourceContainer.getMainEntry();
                    int stackSize = MathHelper.func_76125_a((int)((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputSize, (int)1, (int)itemStack.func_77976_d());
                    itemStack.func_190920_e(stackSize);
                    recipeList.add((IRecipe)new ShapelessOreRecipe(new ResourceLocation("unidict", uniResourceContainer.name + ".x" + ((ShapelessRecipeTemplate)shapelessRecipeTemplate).outputSize + "_size." + ((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs.length + ".template"), itemStack, UniDictCraftTweakerPlugin.kindShapeToActualShape(((ShapelessRecipeTemplate)shapelessRecipeTemplate).inputs, resource)));
                });
            }
        });
    }

    private static Object[] kindShapeToActualShape(@Nonnull Object[] inputs, @Nonnull Resource resource) {
        Object[] newInputKinds = new Object[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            int kind;
            Object input = inputs[i];
            int n = kind = input instanceof String ? Resource.getKindFromName((String)input) : 0;
            newInputKinds[i] = kind != 0 ? resource.getChild((int)kind).name : (input instanceof MCItemStack && ((MCItemStack)input).getInternal() instanceof ItemStack ? ((MCItemStack)input).getInternal() : (input instanceof MCOreDictEntry ? ((MCOreDictEntry)input).getName() : input));
        }
        return newInputKinds;
    }

    private static class ShapelessRecipeTemplate
    implements IAction {
        private final String outputKind;
        private final int outputSize;
        private final Object[] inputs;

        private ShapelessRecipeTemplate(@Nonnull String output, int outputSize, @Nonnull Object[] inputs) {
            this.outputKind = output;
            this.outputSize = outputSize;
            this.inputs = inputs;
        }

        public void apply() {
            NEW_SHAPELESS_RECIPE_TEMPLATE_LIST.add(this);
        }

        public String describe() {
            return "Trying to create a Shapeless Recipe Template for kind: " + this.outputKind;
        }
    }

    private static class ShapedRecipeTemplate
    implements IAction {
        private final String outputKind;
        private final int outputSize;
        private final Object[][] inputs;

        private ShapedRecipeTemplate(@Nonnull String outputKind, int outputSize, @Nonnull Object[][] inputs) {
            this.outputKind = outputKind;
            this.outputSize = outputSize;
            this.inputs = inputs;
        }

        public void apply() {
            NEW_SHAPED_RECIPE_TEMPLATE_LIST.add(this);
        }

        public String describe() {
            return "Trying to create a Shaped Recipe Template for kind: " + this.outputKind;
        }
    }
}

