/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.arithmetics;

import java.math.BigInteger;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.shaded.org.apache.commons.math3.fraction.BigFraction;

public class FullBigFractionArithmetic
implements IValueArithmetic<BigFraction> {
    private final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);

    @Override
    public boolean isZero(BigFraction value) {
        return BigFraction.ZERO.equals(value);
    }

    @Override
    public BigFraction getZero() {
        return BigFraction.ZERO;
    }

    @Override
    public BigFraction add(BigFraction a, BigFraction b) {
        if (this.isFree(a)) {
            return b;
        }
        if (this.isFree(b)) {
            return a;
        }
        return a.add(b);
    }

    @Override
    public BigFraction mul(long a, BigFraction b) {
        if (this.isFree(b)) {
            return this.getFree();
        }
        return b.multiply(a);
    }

    @Override
    public BigFraction div(BigFraction a, long b) {
        if (this.isFree(a)) {
            return this.getFree();
        }
        if (b == 0L) {
            return BigFraction.ZERO;
        }
        BigFraction result = a.divide(b);
        if (result.getNumerator().compareTo(this.MAX_LONG) > 0 || result.getDenominator().compareTo(this.MAX_LONG) > 0) {
            return BigFraction.ZERO;
        }
        return result;
    }

    @Override
    public BigFraction getFree() {
        return new BigFraction(Long.MIN_VALUE);
    }

    @Override
    public boolean isFree(BigFraction value) {
        return value.getNumeratorAsLong() == Long.MIN_VALUE;
    }
}

