/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.container.LongContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class RelayMK1Container
extends LongContainer {
    final RelayMK1Tile tile;
    public double kleinChargeProgress = 0.0;
    public double inputBurnProgress = 0.0;
    public long emc = 0L;

    public RelayMK1Container(InventoryPlayer invPlayer, RelayMK1Tile relay) {
        this.tile = relay;
        this.initSlots(invPlayer);
    }

    void initSlots(InventoryPlayer invPlayer) {
        int j;
        int i;
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 67, 43, SlotPredicates.RELAY_INV));
        int counter = input.getSlots() - 1;
        for (i = 0; i <= 1; ++i) {
            for (j = 0; j <= 2; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter--, 27 + i * 18, 17 + j * 18, SlotPredicates.RELAY_INV));
            }
        }
        this.func_75146_a((Slot)new ValidatedSlot(output, 0, 127, 43, SlotPredicates.IITEMEMC));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 95 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 153));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        PacketHandler.sendProgressBarUpdateLong(listener, this, 0, this.tile.getStoredEmc());
        PacketHandler.sendProgressBarUpdateInt(listener, this, 1, (int)(this.tile.getItemChargeProportion() * 8000.0));
        PacketHandler.sendProgressBarUpdateInt(listener, this, 2, (int)(this.tile.getInputBurnProportion() * 8000.0));
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.emc != this.tile.getStoredEmc()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateLong(icrafting, this, 0, this.tile.getStoredEmc());
            }
            this.emc = this.tile.getStoredEmc();
        }
        if (this.kleinChargeProgress != this.tile.getItemChargeProportion()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 1, (int)(this.tile.getItemChargeProportion() * 8000.0));
            }
            this.kleinChargeProgress = this.tile.getItemChargeProportion();
        }
        if (this.inputBurnProgress != this.tile.getInputBurnProportion()) {
            for (IContainerListener icrafting : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(icrafting, this, 2, (int)(this.tile.getInputBurnProportion() * 8000.0));
            }
            this.inputBurnProgress = this.tile.getInputBurnProportion();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.emc = data;
                break;
            }
            case 1: {
                this.kleinChargeProgress = (double)data / 8000.0;
                break;
            }
            case 2: {
                this.inputBurnProgress = (double)data / 8000.0;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBarLong(int id, long data) {
        switch (id) {
            case 0: {
                this.emc = data;
                break;
            }
            default: {
                this.func_75137_b(id, (int)data);
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex < 8) {
            if (!this.func_75135_a(stack, 8, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, 7, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, newStack);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == ObjHandler.relay && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }
}

