/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class LifeStone
extends RingToggle
implements IBauble,
IPedestalItem {
    public LifeStone() {
        super("life_stone");
        this.setNoRepair();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (ItemHelper.getOrCreateCompound(stack).func_74767_n("Active")) {
            if (!LifeStone.consumeFuel(player, stack, 128L, false)) {
                stack.func_77978_p().func_74757_a("Active", false);
            } else {
                ((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).activateFeed();
                ((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).activateHeal();
                if (player.func_110143_aJ() < player.func_110138_aP() && ((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).canHeal()) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_70691_i(2.0f);
                    LifeStone.removeEmc(stack, 64L);
                }
                if (player.func_71024_bL().func_75121_c() && ((InternalTimers)player.getCapability(InternalTimers.CAPABILITY, null)).canFeed()) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_71024_bL().func_75122_a(2, 10.0f);
                    LifeStone.removeEmc(stack, 64L);
                }
            }
        }
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        NBTTagCompound tag;
        tag.func_74757_a("Active", !(tag = ItemHelper.getOrCreateCompound(stack)).func_74767_n("Active"));
        return true;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.func_130014_f_(), (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.lifePedCooldown != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                List players = world.func_72872_a(EntityPlayerMP.class, tile.getEffectBounds());
                for (EntityPlayerMP player : players) {
                    if (player.func_110143_aJ() < player.func_110138_aP()) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_70691_i(1.0f);
                    }
                    if (!player.func_71024_bL().func_75121_c()) continue;
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.HEAL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_71024_bL().func_75122_a(1, 1.0f);
                }
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.lifePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.pedestalCooldown.lifePedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.life.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.life.pedestal2", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.lifePedCooldown)}));
        }
        return list;
    }
}

