/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.random.WeightedItemStack;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ItemData {
    public static boolean parseItemList(ConfigValue itemEntry, List<WeightedItemStack> list) {
        if (itemEntry.valueType() == ConfigValueType.LIST) {
            ConfigList configList = (ConfigList)itemEntry;
            int e = configList.size();
            for (int i = 0; i < e; ++i) {
                WeightedItemStack entry = ItemData.parseItemEntry((ConfigValue)configList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedItemStack entry = ItemData.parseItemEntry(itemEntry);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedItemStack parseItemEntry(ConfigValue itemEntry) {
        ItemStack stack;
        if (itemEntry.valueType() == ConfigValueType.NULL) {
            return null;
        }
        int metadata = 0;
        int stackSize = 1;
        int chance = 100;
        if (itemEntry.valueType() != ConfigValueType.OBJECT) {
            stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(String.valueOf(itemEntry.unwrapped()))), 1, metadata);
        } else {
            Config itemObject = ((ConfigObject)itemEntry).toConfig();
            if (itemObject.hasPath("metadata")) {
                metadata = itemObject.getInt("metadata");
            }
            if (itemObject.hasPath("count")) {
                stackSize = itemObject.getInt("count");
            } else if (itemObject.hasPath("stack-size")) {
                stackSize = itemObject.getInt("stack-size");
            } else if (itemObject.hasPath("amount")) {
                stackSize = itemObject.getInt("amount");
            }
            if (stackSize <= 0) {
                stackSize = 1;
            }
            if (itemObject.hasPath("weight")) {
                chance = itemObject.getInt("weight");
            }
            if (itemObject.hasPath("ore-name")) {
                String oreName = itemObject.getString("ore-name");
                if (!Utils.oreNameExists(oreName)) {
                    CoFHWorld.log.error("Invalid ore name `{}` for item at line {}!", (Object)oreName, (Object)itemEntry.origin().lineNumber());
                    return null;
                }
                ItemStack oreStack = (ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0);
                stack = Utils.cloneStack(oreStack, stackSize);
            } else {
                if (!itemObject.hasPath("name")) {
                    CoFHWorld.log.error("Item entry missing valid name or ore name at line {}!", (Object)itemEntry.origin().lineNumber());
                    return null;
                }
                stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemObject.getString("name"))), stackSize, metadata);
            }
            if (itemObject.hasPath("nbt")) {
                try {
                    NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)itemObject.getString("nbt"));
                    stack.func_77982_d(tagCompound);
                }
                catch (NBTException t) {
                    CoFHWorld.log.error("Item has invalid NBT data at line {}.", (Object)itemObject.getValue("nbt").origin().lineNumber(), (Object)t);
                }
            }
        }
        return new WeightedItemStack(stack, chance);
    }
}

