/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.item.EnumDyeColor;

public enum EnumWireColour {
    WHITE(EnumDyeColor.WHITE, EnumDyeColor.SILVER, EnumDyeColor.GRAY, EnumDyeColor.BLACK),
    ORANGE(EnumDyeColor.ORANGE, new EnumDyeColor[0]),
    LIGHT_BLUE(EnumDyeColor.LIGHT_BLUE, EnumDyeColor.CYAN),
    YELLOW(EnumDyeColor.YELLOW, new EnumDyeColor[0]),
    LIME(EnumDyeColor.LIME, new EnumDyeColor[0]),
    PINK(EnumDyeColor.PINK, EnumDyeColor.MAGENTA),
    PURPLE(EnumDyeColor.PURPLE, new EnumDyeColor[0]),
    BLUE(EnumDyeColor.BLUE, new EnumDyeColor[0]),
    BROWN(EnumDyeColor.BROWN, new EnumDyeColor[0]),
    GREEN(EnumDyeColor.GREEN, new EnumDyeColor[0]),
    RED(EnumDyeColor.RED, new EnumDyeColor[0]);

    private static final EnumMap<EnumDyeColor, EnumWireColour> DYE_TO_WIRE;
    public final EnumDyeColor primaryIdenticalColour;
    public final Set<EnumDyeColor> similarBasedColours;

    private EnumWireColour(EnumDyeColor primary, EnumDyeColor ... secondary) {
        this.primaryIdenticalColour = primary;
        this.similarBasedColours = EnumSet.of(primary, secondary);
    }

    public static EnumWireColour convertToWire(EnumDyeColor dye) {
        return DYE_TO_WIRE.get(dye);
    }

    static {
        DYE_TO_WIRE = new EnumMap(EnumDyeColor.class);
        for (EnumWireColour enumWireColour : EnumWireColour.values()) {
            for (EnumDyeColor dye : enumWireColour.similarBasedColours) {
                EnumWireColour prev = DYE_TO_WIRE.put(dye, enumWireColour);
                if (prev == null) continue;
                throw new Error((Object)((Object)enumWireColour) + " attempted to override " + (Object)((Object)prev) + " for the dye " + dye + "!");
            }
        }
        for (EnumWireColour enumWireColour : EnumDyeColor.values()) {
            EnumWireColour wire = DYE_TO_WIRE.get((Object)enumWireColour);
            if (wire != null) continue;
            throw new Error((Object)((Object)enumWireColour) + " isn't mapped to a wire colour!");
        }
    }
}

