/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.jei.factory;

import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.compat.module.jei.factory.CategoryHeatable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrapperHeatable
implements IRecipeWrapper {
    private final IRefineryRecipeManager.IHeatableRecipe heatable;
    private final ImmutableList<FluidStack> in;
    private final ImmutableList<FluidStack> out;
    private final IDrawableAnimated animated;

    public WrapperHeatable(IGuiHelper guiHelper, IRefineryRecipeManager.IHeatableRecipe recipe) {
        this.heatable = recipe;
        this.in = ImmutableList.of((Object)recipe.in());
        this.out = recipe.out() != null ? ImmutableList.of((Object)recipe.out()) : ImmutableList.of();
        IDrawableStatic overComplete = guiHelper.createDrawable(CategoryHeatable.energyHeaterBackground, 176, 152, 54, 19);
        this.animated = guiHelper.createAnimatedDrawable(overComplete, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(FluidStack.class, this.in);
        ingredients.setOutputs(FluidStack.class, this.out);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.animated.draw(minecraft, 18, 0);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

