/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonVariableFaceUV;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.client.model.json.VariablePartCuboidBase;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.misc.RenderUtil;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class VariablePartTextureExpand
extends JsonVariableModelPart {
    public final IExpressionNode.INodeDouble[] from;
    public final IExpressionNode.INodeDouble[] to;
    public final IExpressionNode.INodeBoolean visible;
    public final IExpressionNode.INodeBoolean shade;
    public final IExpressionNode.INodeLong light;
    public final IExpressionNode.INodeLong colour;
    public final IExpressionNode.INodeObject<String> face;
    public final JsonVariableFaceUV faceUv;
    private final Set<String> invalidFaceStrings = new HashSet<String>();

    public VariablePartTextureExpand(JsonObject obj, FunctionContext fnCtx) {
        this.from = VariablePartTextureExpand.readVariablePosition(obj, "from", fnCtx);
        this.to = VariablePartTextureExpand.readVariablePosition(obj, "to", fnCtx);
        this.shade = obj.has("shade") ? VariablePartTextureExpand.readVariableBoolean(obj, "shade", fnCtx) : NodeConstantBoolean.TRUE;
        this.visible = obj.has("visible") ? VariablePartTextureExpand.readVariableBoolean(obj, "visible", fnCtx) : NodeConstantBoolean.TRUE;
        this.light = obj.has("light") ? VariablePartTextureExpand.readVariableLong(obj, "light", fnCtx) : new NodeConstantLong(0L);
        this.colour = obj.has("colour") ? VariablePartTextureExpand.readVariableLong(obj, "colour", fnCtx) : new NodeConstantLong(-1L);
        this.face = VariablePartTextureExpand.readVariableString(obj, "face", fnCtx);
        this.faceUv = new JsonVariableFaceUV(obj, fnCtx);
    }

    @Override
    public void addQuads(List<MutableQuad> addTo, JsonVariableModel.ITextureGetter spriteLookup) {
        if (this.visible.evaluate()) {
            float[] f = VariablePartTextureExpand.bakePosition(this.from);
            float[] t = VariablePartTextureExpand.bakePosition(this.to);
            float[] size = new float[]{t[0] - f[0], t[1] - f[1], t[2], f[2]};
            boolean s = this.shade.evaluate();
            int l = (int)(this.light.evaluate() & 0xFL);
            int rgba = RenderUtil.swapARGBforABGR((int)this.colour.evaluate());
            VariablePartCuboidBase.VariableFaceData data = this.faceUv.evaluate(spriteLookup);
            ItemLayerModel model = new ItemLayerModel(ImmutableList.of((Object)new ResourceLocation(".")));
            IBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, loc -> data.sprite);
            List quads = baked.func_188616_a(null, null, 0L);
            for (BakedQuad q : quads) {
                MutableQuad mut = new MutableQuad();
                mut.fromBakedItem(q);
                mut.translated(0.0, 0.0, -0.46875);
                mut.scaled(1.0, 1.0, 16.0);
                mut.rotate(EnumFacing.SOUTH, this.evaluateFace(this.face), 0.5f, 0.5f, 0.5f);
                mut.scalef(size[0], size[1], size[2]);
                mut.translated(f[0], f[1], f[2]);
                mut.setCalculatedNormal();
                mut.setShade(s);
                mut.lighti(l, 0);
                mut.colouri(rgba);
                mut.setSprite(data.sprite);
                addTo.add(mut);
            }
        }
    }

    private EnumFacing evaluateFace(IExpressionNode.INodeObject<String> node) {
        String s = node.evaluate();
        EnumFacing side = EnumFacing.func_176739_a((String)s);
        if (side == null) {
            if (this.invalidFaceStrings.add(s)) {
                BCLog.logger.warn("Invalid facing '" + s + "' from expression '" + node + "'");
            }
            return EnumFacing.UP;
        }
        return side;
    }
}

