/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.gui.pos.IGuiArea;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpriteNineSliced {
    public final ISprite sprite;
    public final double xMin;
    public final double yMin;
    public final double xMax;
    public final double yMax;
    public final double xScale;
    public final double yScale;

    public SpriteNineSliced(ISprite sprite, int xMin, int yMin, int xMax, int yMax, int textureSize) {
        this(sprite, xMin, yMin, xMax, yMax, textureSize, textureSize);
    }

    public SpriteNineSliced(ISprite sprite, int xMin, int yMin, int xMax, int yMax, int xScale, int yScale) {
        this.sprite = sprite;
        this.xMin = (double)xMin / (double)xScale;
        this.yMin = (double)yMin / (double)yScale;
        this.xMax = (double)xMax / (double)xScale;
        this.yMax = (double)yMax / (double)yScale;
        this.xScale = xScale;
        this.yScale = yScale;
    }

    public SpriteNineSliced(ISprite sprite, double xMin, double yMin, double xMax, double yMax, double scale) {
        this(sprite, xMin, yMin, xMax, yMax, scale, scale);
    }

    public SpriteNineSliced(ISprite sprite, double xMin, double yMin, double xMax, double yMax, double xScale, double yScale) {
        this.sprite = sprite;
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.xScale = xScale;
        this.yScale = yScale;
    }

    public void draw(IGuiArea element) {
        this.draw(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public void draw(double x, double y, double width, double height) {
        this.sprite.bindTexture();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_178969_c(x, y, 0.0);
        double sx = this.xScale;
        double sy = this.yScale;
        double[] xa = new double[]{0.0, this.xMin * sx, width + (this.xMax - 1.0) * sx, width};
        double[] ya = new double[]{0.0, this.yMin * sy, height + (this.yMax - 1.0) * sy, height};
        double[] ua = new double[]{0.0, this.xMin, this.xMax, 1.0};
        double[] va = new double[]{0.0, this.yMin, this.yMax, 1.0};
        this.quad(vb, xa, ya, ua, va, 0, 0);
        this.quad(vb, xa, ya, ua, va, 0, 1);
        this.quad(vb, xa, ya, ua, va, 0, 2);
        this.quad(vb, xa, ya, ua, va, 1, 0);
        this.quad(vb, xa, ya, ua, va, 1, 1);
        this.quad(vb, xa, ya, ua, va, 1, 2);
        this.quad(vb, xa, ya, ua, va, 2, 0);
        this.quad(vb, xa, ya, ua, va, 2, 1);
        this.quad(vb, xa, ya, ua, va, 2, 2);
        tess.func_78381_a();
        vb.func_178969_c(0.0, 0.0, 0.0);
    }

    private void quad(BufferBuilder vb, double[] x, double[] y, double[] u, double[] v, int xIndex, int yIndex) {
        int xis = xIndex;
        int xIB = xIndex + 1;
        int yis = yIndex;
        int yIB = yIndex + 1;
        this.vertex(vb, x[xis], y[yis], u[xis], v[yis]);
        this.vertex(vb, x[xis], y[yIB], u[xis], v[yIB]);
        this.vertex(vb, x[xIB], y[yIB], u[xIB], v[yIB]);
        this.vertex(vb, x[xIB], y[yis], u[xIB], v[yis]);
    }

    private void vertex(BufferBuilder vb, double x, double y, double texU, double texV) {
        vb.func_181662_b(x, y, 0.0);
        vb.func_187315_a(this.sprite.getInterpU(texU), this.sprite.getInterpV(texV));
        vb.func_181675_d();
    }
}

