/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.IPayloadReceiver;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageUpdateTile
implements IMessage {
    private BlockPos pos;
    private PacketBufferBC payload;
    public static final IMessageHandler<MessageUpdateTile, IMessage> HANDLER = (message, ctx) -> {
        try {
            EntityPlayer player = BCLibProxy.getProxy().getPlayerForContext(ctx);
            if (player == null || player.field_70170_p == null) {
                IMessage iMessage = null;
                return iMessage;
            }
            TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
            if (tile instanceof IPayloadReceiver) {
                IMessage iMessage = ((IPayloadReceiver)tile).receivePayload(ctx, message.payload);
                return iMessage;
            }
            BCLog.logger.warn("Dropped message for player " + player.func_70005_c_() + " for tile at " + message.pos + " (found " + tile + ")");
            IMessage iMessage = null;
            return iMessage;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        finally {
            message.payload.release();
        }
    };

    public MessageUpdateTile() {
    }

    public MessageUpdateTile(BlockPos pos, PacketBufferBC payload) {
        this.pos = pos;
        this.payload = payload;
        if (this.getPayloadSize() > 0x1000000) {
            throw new IllegalStateException("Can't write out " + this.getPayloadSize() + "bytes!");
        }
    }

    public int getPayloadSize() {
        return this.payload == null ? 0 : this.payload.readableBytes();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = MessageUtil.readBlockPos(new PacketBuffer(buf));
        int size = buf.readUnsignedMedium();
        this.payload = new PacketBufferBC(buf.readBytes(size));
    }

    public void toBytes(ByteBuf buf) {
        MessageUtil.writeBlockPos(new PacketBuffer(buf), this.pos);
        int length = this.payload.readableBytes();
        buf.writeMedium(length);
        buf.writeBytes((ByteBuf)this.payload, 0, length);
    }
}

