/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.net;

import buildcraft.lib.net.MessageManager;
import buildcraft.transport.net.MessageMultiPipeItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PipeItemMessageQueue {
    private static final Map<EntityPlayerMP, MessageMultiPipeItem> cachedPlayerPackets = new WeakHashMap<EntityPlayerMP, MessageMultiPipeItem>();

    public static void serverTick() {
        for (Map.Entry<EntityPlayerMP, MessageMultiPipeItem> entry : cachedPlayerPackets.entrySet()) {
            MessageManager.sendTo(entry.getValue(), entry.getKey());
        }
        cachedPlayerPackets.clear();
    }

    public static void appendTravellingItem(World world, BlockPos pos, int stackId, byte stackCount, boolean toCenter, EnumFacing side, @Nullable EnumDyeColor colour, byte timeToDest) {
        WorldServer server = (WorldServer)world;
        PlayerChunkMapEntry playerChunkMap = server.func_184164_w().func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (playerChunkMap == null) {
            return;
        }
        ArrayList players = new ArrayList();
        playerChunkMap.func_187271_a(0.0, player -> {
            players.add(player);
            return false;
        });
        for (EntityPlayerMP player2 : players) {
            cachedPlayerPackets.computeIfAbsent(player2, pl -> new MessageMultiPipeItem()).append(pos, stackId, stackCount, toCenter, side, colour, timeToDest);
        }
    }
}

