/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec;

import codechicken.lib.util.Copyable;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class Cuboid6
implements Copyable<Cuboid6> {
    public static Cuboid6 full = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public Vector3 min;
    public Vector3 max;

    public Cuboid6() {
        this(new Vector3(), new Vector3());
    }

    public Cuboid6(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Cuboid6(Vec3i min, Vec3i max) {
        this.min = Vector3.fromVec3i(min);
        this.max = Vector3.fromVec3i(max);
    }

    public Cuboid6(AxisAlignedBB aabb) {
        this.min = new Vector3(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.max = new Vector3(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Cuboid6(NBTTagCompound tag) {
        this(Vector3.fromNBT(tag.func_74775_l("min")), Vector3.fromNBT(tag.func_74775_l("max")));
    }

    public Cuboid6(Cuboid6 cuboid) {
        this.min = cuboid.min.copy();
        this.max = cuboid.max.copy();
    }

    public Cuboid6(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min = new Vector3(minx, miny, minz);
        this.max = new Vector3(maxx, maxy, maxz);
    }

    public AxisAlignedBB aabb() {
        return new AxisAlignedBB(this.min.x, this.min.y, this.min.z, this.max.x, this.max.y, this.max.z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("min", (NBTBase)this.min.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("max", (NBTBase)this.max.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public Cuboid6 set(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min.set(minx, miny, minz);
        this.max.set(maxx, maxy, maxz);
        return this;
    }

    public Cuboid6 set(Vector3 min, Vector3 max) {
        return this.set(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public Cuboid6 set(Vec3i min, Vec3i max) {
        return this.set(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public Cuboid6 set(Cuboid6 c) {
        return this.set(c.min.x, c.min.y, c.min.z, c.max.x, c.max.y, c.max.z);
    }

    public Cuboid6 add(double dx, double dy, double dz) {
        this.min.add(dx, dy, dz);
        this.max.add(dx, dy, dz);
        return this;
    }

    public Cuboid6 add(double d) {
        return this.add(d, d, d);
    }

    public Cuboid6 add(Vector3 vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Cuboid6 add(Vec3i vec) {
        return this.add(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Cuboid6 add(BlockPos pos) {
        return this.add(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Cuboid6 subtract(double dx, double dy, double dz) {
        this.min.subtract(dx, dy, dz);
        this.max.subtract(dx, dy, dz);
        return this;
    }

    public Cuboid6 subtract(double d) {
        return this.subtract(d, d, d);
    }

    public Cuboid6 subtract(Vector3 vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Cuboid6 subtract(Vec3i vec) {
        return this.subtract(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Cuboid6 subtract(BlockPos pos) {
        return this.subtract(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Cuboid6 expand(double dx, double dy, double dz) {
        this.min.subtract(dx, dy, dz);
        this.max.add(dx, dy, dz);
        return this;
    }

    public Cuboid6 expand(double d) {
        return this.expand(d, d, d);
    }

    public Cuboid6 expand(Vector3 vec) {
        return this.expand(vec.x, vec.y, vec.z);
    }

    public Cuboid6 expandSide(EnumFacing side, int amount) {
        switch (side.func_176743_c()) {
            case NEGATIVE: {
                this.min.add(Vector3.fromVec3i(side.func_176730_m()).multiply(amount));
                break;
            }
            case POSITIVE: {
                this.max.add(Vector3.fromVec3i(side.func_176730_m()).multiply(amount));
            }
        }
        return this;
    }

    public Cuboid6 shrinkSide(EnumFacing side, int amount) {
        this.expandSide(side, -amount);
        return this;
    }

    public Cuboid6 offset(Cuboid6 o) {
        this.min.add(o.min);
        this.max.add(o.max);
        return this;
    }

    public Cuboid6 enclose(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        if (this.min.x > minx) {
            this.min.x = minx;
        }
        if (this.min.y > miny) {
            this.min.y = miny;
        }
        if (this.min.z > minz) {
            this.min.z = minz;
        }
        if (this.max.x < maxx) {
            this.max.x = maxx;
        }
        if (this.max.y < maxy) {
            this.max.y = maxy;
        }
        if (this.max.z < maxz) {
            this.max.z = maxz;
        }
        return this;
    }

    public Cuboid6 enclose(double x, double y, double z) {
        return this.enclose(x, y, z, x, y, z);
    }

    public Cuboid6 enclose(Vector3 vec) {
        return this.enclose(vec.x, vec.y, vec.z, vec.x, vec.y, vec.z);
    }

    public Cuboid6 enclose(Cuboid6 c) {
        return this.enclose(c.min.x, c.min.y, c.min.z, c.max.x, c.max.y, c.max.z);
    }

    public boolean contains(double x, double y, double z) {
        return this.min.x - 1.0E-5 <= x && this.min.y - 1.0E-5 <= y && this.min.z - 1.0E-5 <= z && this.max.x + 1.0E-5 >= x && this.max.y + 1.0E-5 >= y && this.max.z + 1.0E-5 >= z;
    }

    public boolean contains(Vector3 vec) {
        return this.contains(vec.x, vec.y, vec.z);
    }

    public boolean intersects(Cuboid6 b) {
        return this.max.x - 1.0E-5 > b.min.x && this.max.y - 1.0E-5 > b.min.y && this.max.z - 1.0E-5 > b.min.z && b.max.x - 1.0E-5 > this.min.x && b.max.y - 1.0E-5 > this.min.y && b.max.z - 1.0E-5 > this.min.z;
    }

    public double volume() {
        return (this.max.x - this.min.x + 1.0) * (this.max.y - this.min.y + 1.0) * (this.max.z - this.min.z + 1.0);
    }

    public Vector3 center() {
        return this.min.copy().add(this.max).multiply(0.5);
    }

    public double getSideSize(EnumFacing side) {
        switch (side.func_176740_k()) {
            case X: {
                return this.max.x - this.min.x + 1.0;
            }
            case Y: {
                return this.max.y - this.min.y + 1.0;
            }
            case Z: {
                return this.max.z - this.min.z + 1.0;
            }
        }
        return 0.0;
    }

    public double getSide(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return this.min.y;
            }
            case UP: {
                return this.max.y;
            }
            case NORTH: {
                return this.min.z;
            }
            case SOUTH: {
                return this.max.z;
            }
            case WEST: {
                return this.min.x;
            }
            case EAST: {
                return this.max.x;
            }
        }
        return 0.0;
    }

    @Deprecated
    public double getSide(int s) {
        return this.getSide(EnumFacing.values()[s]);
    }

    public Cuboid6 setSide(EnumFacing side, double d) {
        switch (side) {
            case DOWN: {
                this.min.y = d;
                break;
            }
            case UP: {
                this.max.y = d;
                break;
            }
            case NORTH: {
                this.min.z = d;
                break;
            }
            case SOUTH: {
                this.max.z = d;
                break;
            }
            case WEST: {
                this.min.x = d;
                break;
            }
            case EAST: {
                this.max.x = d;
            }
        }
        return this;
    }

    @Deprecated
    public Cuboid6 setSide(int s, double d) {
        return this.setSide(EnumFacing.values()[s], d);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cuboid6)) {
            return false;
        }
        Cuboid6 c = (Cuboid6)obj;
        return this.min.equals(c.min) && this.max.equals(c.max);
    }

    public boolean equalsT(Cuboid6 c) {
        return this.min.equalsT(c.min) && this.max.equalsT(c.max);
    }

    @Override
    public Cuboid6 copy() {
        return new Cuboid6(this);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Cuboid: (" + new BigDecimal(this.min.x, cont) + ", " + new BigDecimal(this.min.y, cont) + ", " + new BigDecimal(this.min.z, cont) + ") -> (" + new BigDecimal(this.max.x, cont) + ", " + new BigDecimal(this.max.y, cont) + ", " + new BigDecimal(this.max.z, cont) + ")";
    }

    public Cuboid6 apply(Transformation t) {
        double temp;
        t.apply(this.min);
        t.apply(this.max);
        if (this.min.x > this.max.x) {
            temp = this.min.x;
            this.min.x = this.max.x;
            this.max.x = temp;
        }
        if (this.min.y > this.max.y) {
            temp = this.min.y;
            this.min.y = this.max.y;
            this.max.y = temp;
        }
        if (this.min.z > this.max.z) {
            temp = this.min.z;
            this.min.z = this.max.z;
            this.max.z = temp;
        }
        return this;
    }
}

