/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import me.jellysquid.mods.lithium.asm.FieldRef;
import me.jellysquid.mods.lithium.asm.MethodRef;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMUtil {
    public static final Logger LOGGER = LogManager.getLogger();

    public static Collection<FieldNode> matchFields(ClassNode classNode, Collection<FieldRef> refs) {
        return ASMUtil.matchRefs(classNode.fields, refs, method -> new FieldRef(classNode.name, method.name, method.desc));
    }

    public static Collection<MethodNode> matchMethods(ClassNode classNode, Collection<MethodRef> refs) {
        return ASMUtil.matchRefs(classNode.methods, refs, method -> new MethodRef(method.name, method.desc));
    }

    public static String getPathNotation(String intermediary) {
        return intermediary.replace('.', '/');
    }

    private static <K, T> Collection<K> matchRefs(Collection<K> nodes, Collection<T> refs, Function<K, T> nameFunction) {
        HashSet<T> missing = new HashSet<T>(refs);
        ArrayList<K> matched = new ArrayList<K>();
        Iterator<K> nodeIterator = nodes.iterator();
        while (nodeIterator.hasNext() && !missing.isEmpty()) {
            K node = nodeIterator.next();
            T ref = nameFunction.apply(node);
            if (!missing.remove(ref)) continue;
            matched.add(node);
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Could not locate: " + ArrayUtils.toString(missing));
        }
        return matched;
    }
}

