/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm.patches;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import me.jellysquid.mods.lithium.asm.FieldRef;
import me.jellysquid.mods.lithium.asm.MethodRef;
import me.jellysquid.mods.lithium.asm.consumers.FieldAccessTransformer;
import me.jellysquid.mods.lithium.asm.consumers.FieldCleaner;
import me.jellysquid.mods.lithium.asm.consumers.FieldRemapper;
import me.jellysquid.mods.lithium.asm.consumers.MethodCleaner;
import me.jellysquid.mods.lithium.asm.consumers.PatchSetTransformer;
import org.objectweb.asm.tree.ClassNode;

public class DevirtualizeBlockPosTransformer {
    private static final String BLOCK_POS_MUTABLE_CLASS_NAME = "net/minecraft/util/math/BlockPos$Mutable";
    private static final String VEC3I_CLASS_NAME = "net/minecraft/util/math/Vec3i";

    public static void install(HashMap<String, Consumer<ClassNode>> map) {
        FieldRef blockPosX = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_177997_b", "I");
        FieldRef blockPosY = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_177998_c", "I");
        FieldRef blockPosZ = FieldRef.intermediary(BLOCK_POS_MUTABLE_CLASS_NAME, "field_177996_d", "I");
        FieldRef vecX = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_177962_a", "I");
        FieldRef vecY = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_177960_b", "I");
        FieldRef vecZ = FieldRef.intermediary(VEC3I_CLASS_NAME, "field_177961_c", "I");
        map.put(BLOCK_POS_MUTABLE_CLASS_NAME, new PatchSetTransformer("Use mutable fields in Vec3i", Arrays.asList(new FieldCleaner(blockPosX, blockPosY, blockPosZ), new MethodCleaner(MethodRef.intermediary("func_177958_n", "()I"), MethodRef.intermediary("func_177956_o", "()I"), MethodRef.intermediary("func_177952_p", "()I")), new FieldRemapper(new FieldRemapper.FieldMapping(blockPosX, vecX), new FieldRemapper.FieldMapping(blockPosY, vecY), new FieldRemapper.FieldMapping(blockPosZ, vecZ)))));
        map.put(VEC3I_CLASS_NAME, new PatchSetTransformer("Modify mutability flags in Vec3i", Collections.singletonList(new FieldAccessTransformer(4, vecX, vecY, vecZ))));
    }
}

