/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block.redstone.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.jellysquid.mods.lithium.common.block.redstone.RedstoneLogic;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateFlag;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateGraph;
import me.jellysquid.mods.lithium.common.block.redstone.graph.UpdateNodeBlockType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class UpdateNode {
    private final UpdateGraph graph;
    private final BlockPos pos;
    private final UpdateNode[] adjacentNodes = new UpdateNode[6];
    private final List<UpdateNode> connections = new ArrayList<UpdateNode>(0);
    private BlockState state;
    private UpdateNodeBlockType type;
    private byte currentWirePower = 0;
    private byte darkeningThreshold = (byte)-1;
    private byte flags;

    UpdateNode(UpdateGraph graph, BlockPos pos) {
        this.graph = graph;
        this.pos = pos.func_185334_h();
        this.invalidateWorldState();
    }

    public UpdateNode getAdjacent(Direction dir) {
        UpdateNode adj = this.adjacentNodes[dir.ordinal()];
        if (adj == null) {
            adj = this.graph.getOrCreateNode(this.pos.func_177972_a(dir));
            adj.adjacentNodes[dir.func_176734_d().ordinal()] = this;
            this.adjacentNodes[dir.ordinal()] = adj;
        }
        return adj;
    }

    public boolean isWireBlock() {
        return this.type == UpdateNodeBlockType.WIRE;
    }

    public boolean isFullBlock() {
        return this.type == UpdateNodeBlockType.FULL_BLOCK;
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public int getCurrentWirePower() {
        return this.currentWirePower;
    }

    public void setCurrentWirePower(int currentWirePower) {
        if (!this.isWireBlock()) {
            throw new IllegalStateException("Not a wire block!");
        }
        this.currentWirePower = (byte)currentWirePower;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    private World getWorld() {
        return this.graph.getWorld();
    }

    public int getOutgoingStrongPower(Direction dir) {
        if (this.isWireBlock()) {
            return 0;
        }
        return this.getBlockState().func_185893_b((IBlockReader)this.getWorld(), this.getPosition(), dir);
    }

    public int getOutgoingWeakPower(Direction dir) {
        if (this.isWireBlock()) {
            return this.getOutgoingWirePower();
        }
        return this.getBlockState().func_185911_a((IBlockReader)this.getWorld(), this.getPosition(), dir);
    }

    private int getOutgoingWirePower() {
        return Math.max(0, this.getCurrentWirePower() - 1);
    }

    public int calculateIncomingEffectivePower() {
        UpdateNode adj;
        int power = 0;
        boolean canAscend = !this.getAdjacent(Direction.UP).isFullBlock();
        for (Direction dir : RedstoneLogic.INCOMING_POWER_DIRECTIONS) {
            adj = this.getAdjacent(dir);
            if (adj.isFullBlock()) {
                power = Math.max(power, adj.calculateIncomingStrongPower());
            }
            power = Math.max(power, adj.getOutgoingWeakPower(dir));
        }
        for (Direction dir : RedstoneLogic.WIRE_NEIGHBORS_HORIZONTAL) {
            adj = this.getAdjacent(dir);
            if (canAscend && adj.isFullBlock()) {
                power = Math.max(power, adj.getAdjacent(Direction.UP).getOutgoingWirePower());
            }
            if (adj.isFullBlock()) continue;
            power = Math.max(power, adj.getAdjacent(Direction.DOWN).getOutgoingWirePower());
        }
        return Math.min(power, 15);
    }

    private int calculateIncomingStrongPower() {
        int power = 0;
        for (Direction dir : RedstoneLogic.INCOMING_POWER_DIRECTIONS) {
            power = Math.max(power, this.getAdjacent(dir).getOutgoingStrongPower(dir));
        }
        return power;
    }

    public void invalidateWorldState() {
        this.state = this.graph.getBlockAccess().getBlockState(this.pos);
        if (this.state.func_177230_c() == Blocks.field_150488_af) {
            this.type = UpdateNodeBlockType.WIRE;
            this.currentWirePower = ((Integer)this.state.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)).byteValue();
        } else if (this.state.func_224756_o((IBlockReader)this.getWorld(), this.getPosition())) {
            this.type = UpdateNodeBlockType.FULL_BLOCK;
            this.currentWirePower = 0;
        } else {
            this.type = UpdateNodeBlockType.NON_FULL_BLOCK;
            this.currentWirePower = 0;
        }
    }

    public void updateWireState() {
        this.state = this.createUpdatedWireState();
        this.graph.getBlockAccess().setBlockState(this.getPosition(), this.state);
    }

    public BlockState createUpdatedWireState() {
        if (!this.isWireBlock()) {
            throw new IllegalStateException("Not a wire block");
        }
        return (BlockState)this.getBlockState().func_206870_a((IProperty)RedstoneWireBlock.field_176351_O, (Comparable)Integer.valueOf(this.getCurrentWirePower()));
    }

    public int getDarkeningThreshold() {
        return this.darkeningThreshold;
    }

    public void setDarkeningThreshold(int power) {
        this.darkeningThreshold = (byte)power;
    }

    public String toString() {
        return String.format("UpdateNode{pos=%s, currentWirePower=%s, darkeningThreshold=%s}", this.pos, this.currentWirePower, this.darkeningThreshold);
    }

    public boolean isWireAtValidLocation() {
        return this.getAdjacent(Direction.DOWN).canSupportWireBlock();
    }

    public boolean canSupportWireBlock() {
        this.invalidateWorldState();
        World world = this.getWorld();
        BlockState state = this.getBlockState();
        BlockPos pos = this.getPosition();
        return state.func_224755_d((IBlockReader)world, pos, Direction.UP) || state.func_177230_c() == Blocks.field_150438_bZ;
    }

    public void destroyWire() {
        Block.func_220075_c((BlockState)this.getBlockState(), (World)this.getWorld(), (BlockPos)this.getPosition());
        this.getWorld().func_217377_a(this.getPosition(), false);
    }

    public void invalidateConnections() {
        this.connections.clear();
    }

    public void addConnection(UpdateNode node) {
        this.connections.add(node);
    }

    public Collection<UpdateNode> getConnections() {
        return Collections.unmodifiableCollection(this.connections);
    }

    public boolean checkAndMarkFlag(UpdateFlag flag) {
        int bit;
        int flags = Byte.toUnsignedInt(this.flags);
        if ((flags & (bit = 1 << flag.ordinal())) != 0) {
            return false;
        }
        this.flags = (byte)(flags | bit);
        return true;
    }

    public void clearFlags() {
        this.flags = 0;
    }

    public void update(UpdateNode origin, Direction dir, boolean updateObservers) {
        BlockState state;
        this.invalidateWorldState();
        BlockState blockState = state = updateObservers ? this.getUpdatedBlockState(origin, dir) : this.getBlockState();
        if (state.func_177230_c() != Blocks.field_150488_af) {
            state.func_215697_a(this.getWorld(), this.getPosition(), Blocks.field_150488_af, origin.getPosition(), false);
        }
    }

    private BlockState getUpdatedBlockState(UpdateNode origin, Direction dir) {
        BlockState state = this.getBlockState();
        if (state.func_177230_c() != Blocks.field_150488_af) {
            BlockState newState = state.func_196956_a(dir.func_176734_d(), state, (IWorld)this.getWorld(), this.getPosition(), origin.getPosition());
            this.replaceBlock(state, newState, (IWorld)this.getWorld(), this.getPosition());
            state = newState;
        }
        return state;
    }

    private void replaceBlock(BlockState state, BlockState updatedState, IWorld world, BlockPos pos) {
        if (updatedState == state) {
            return;
        }
        if (updatedState.func_196958_f()) {
            if (world.func_201670_d()) {
                return;
            }
            world.func_175655_b(pos, true);
        } else {
            this.graph.getBlockAccess().setBlockState(pos, updatedState);
        }
    }
}

