/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.jellysquid.mods.lithium.common.config.annotations.Category;
import me.jellysquid.mods.lithium.common.config.annotations.Option;
import me.jellysquid.mods.lithium.common.config.parser.ConfigParser;

public class LithiumConfig {
    private static final Lock cachedConfigLock = new ReentrantLock();
    private static LithiumConfig cachedConfig;
    public AiConfig ai = new AiConfig();
    public GeneralConfig general = new GeneralConfig();
    public PhysicsConfig physics = new PhysicsConfig();
    public EntityConfig entity = new EntityConfig();
    public ChunkConfig chunk = new ChunkConfig();
    public ClientConfig client = new ClientConfig();
    public OtherConfig other = new OtherConfig();
    public RegionConfig region = new RegionConfig();
    public RedstoneConfig redstone = new RedstoneConfig();
    public WorldConfig world = new WorldConfig();

    public static LithiumConfig instance() {
        cachedConfigLock.lock();
        try {
            if (cachedConfig == null) {
                cachedConfig = LithiumConfig.load(new File("./config/lithium.toml"));
            }
            LithiumConfig lithiumConfig = cachedConfig;
            return lithiumConfig;
        }
        finally {
            cachedConfigLock.unlock();
        }
    }

    public static LithiumConfig load(File file) {
        if (!file.exists()) {
            LithiumConfig.writeDefaultConfig(file);
            return new LithiumConfig();
        }
        try {
            return ConfigParser.deserialize(LithiumConfig.class, file);
        }
        catch (ConfigParser.ParseException e) {
            throw new RuntimeException("Could not parse config", e);
        }
    }

    private static void writeDefaultConfig(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Lithium.\n");
            writer.write("#\n");
            writer.write("# You can find information on editing this file and all the available options here:\n");
            writer.write("# https://github.com/jellysquid3/Lithium/wiki/Configuration-File\n");
            writer.write("#\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write default config", e);
        }
    }

    @Category(value="other")
    public static class OtherConfig {
        @Option(value="use_small_tag_array_optimization")
        public boolean useSmallTagArrayOptimization = true;
    }

    @Category(value="redstone")
    public static class RedstoneConfig {
        @Option(value="use_redstone_dust_optimizations")
        public boolean useRedstoneDustOptimizations = false;
    }

    @Category(value="world")
    public static class WorldConfig {
        @Option(value="use_fast_explosions")
        public boolean useFastExplosions = true;
        @Option(value="use_fast_poi_retrieval")
        public boolean useFastPoiRetrieval = true;
    }

    @Category(value="general")
    public static class GeneralConfig {
        @Option(value="use_fast_list_type_filtering")
        public boolean useFastListTypeFiltering = true;
        @Option(value="use_optimized_tick_scheduler")
        public boolean useOptimizedTickScheduler = true;
        @Option(value="reduce_object_allocations")
        public boolean reduceObjectAllocations = true;
        @Option(value="cache_hashcode_calculations")
        public boolean cacheHashcodeCalculations = true;
        @Option(value="use_fast_math_utility_logic")
        public boolean useFastMathUtilityLogic = true;
        @Option(value="use_block_pos_optimizations")
        public boolean useBlockPosOptimizations = true;
    }

    @Category(value="chunk")
    public static class ChunkConfig {
        @Option(value="use_optimized_hash_palette")
        public boolean useOptimizedHashPalette = true;
        @Option(value="use_fast_palette_compaction")
        public boolean useFastPaletteCompaction = true;
        @Option(value="remove_concurrent_modification_checks")
        public boolean removeConcurrentModificationChecks = false;
    }

    @Category(value="region")
    public static class RegionConfig {
        @Option(value="reduce_session_lock_checks")
        public boolean reduceSessionLockChecks = true;
    }

    @Category(value="entity")
    public static class EntityConfig {
        @Option(value="use_optimized_data_tracker")
        public boolean useOptimizedDataTracker = true;
        @Option(value="avoid_locking_data_tracker")
        public boolean avoidLockingDataTracker = true;
        @Option(value="use_streamless_entity_retrieval")
        public boolean useStreamlessEntityRetrieval = true;
        @Option(value="use_block_at_feet_caching")
        public boolean useBlockAtFeetCaching = true;
    }

    @Category(value="client")
    public static class ClientConfig {
        @Option(value="use_loading_screen_optimizations")
        public boolean useLoadingScreenOptimizations = true;
    }

    @Category(value="physics")
    public static class PhysicsConfig {
        @Option(value="use_fast_shape_comparison")
        public boolean useFastShapeComparisons = true;
        @Option(value="use_fast_world_border_checks")
        public boolean useFastWorldBorderChecks = true;
        @Option(value="use_simple_entity_collision_testing")
        public boolean useSimpleEntityCollisionTesting = true;
        @Option(value="always_unpack_block_shapes")
        public boolean alwaysUnpackBlockShapes = true;
        @Option(value="extend_block_shape_cache")
        public boolean extendBlockShapeCache = true;
    }

    @Category(value="ai")
    public static class AiConfig {
        @Option(value="use_fast_goal_selection")
        public boolean useFastGoalSelection = true;
        @Option(value="use_fast_raid_logic")
        public boolean useFastRaidLogic = true;
        @Option(value="use_nearby_entity_tracking")
        public boolean useNearbyEntityTracking = false;
        @Option(value="use_fast_brain")
        public boolean useFastBrain = true;
    }
}

