/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.chunk.palette;

import java.util.function.Function;
import me.jellysquid.mods.lithium.common.world.chunk.palette.LithiumIntIdentityHashBiMap;
import me.jellysquid.mods.lithium.common.world.chunk.palette.LithiumResizeCallback;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.IPalette;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LithiumPaletteHashMap<T>
implements IPalette<T> {
    private final ObjectIntIdentityMap<T> idList;
    private final LithiumIntIdentityHashBiMap<T> map;
    private final LithiumResizeCallback<T> resizeHandler;
    private final Function<CompoundNBT, T> elementDeserializer;
    private final Function<T, CompoundNBT> elementSerializer;
    private final int indexBits;

    public LithiumPaletteHashMap(ObjectIntIdentityMap<T> ids, int bits, LithiumResizeCallback<T> resizeHandler, Function<CompoundNBT, T> deserializer, Function<T, CompoundNBT> serializer) {
        this.idList = ids;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        this.elementDeserializer = deserializer;
        this.elementSerializer = serializer;
        this.map = new LithiumIntIdentityHashBiMap(1 << bits);
    }

    public int func_186041_a(T obj) {
        int id = this.map.getId(obj);
        if (id == -1 && (id = this.map.add(obj)) >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onLithiumPaletteResized(this.indexBits + 1, obj);
        }
        return id;
    }

    public boolean func_222626_b(T obj) {
        return this.map.containsObject(obj);
    }

    public T func_186039_a(int id) {
        return this.map.func_148745_a(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_186038_a(PacketBuffer buf) {
        this.map.clear();
        int entryCount = buf.func_150792_a();
        for (int i = 0; i < entryCount; ++i) {
            this.map.add(this.idList.func_148745_a(buf.func_150792_a()));
        }
    }

    public void func_186037_b(PacketBuffer buf) {
        int paletteBits = this.getSize();
        buf.func_150787_b(paletteBits);
        for (int i = 0; i < paletteBits; ++i) {
            buf.func_150787_b(this.idList.func_148747_b(this.map.func_148745_a(i)));
        }
    }

    public int func_186040_a() {
        int size = PacketBuffer.func_150790_a((int)this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            size += PacketBuffer.func_150790_a((int)this.idList.func_148747_b(this.map.func_148745_a(i)));
        }
        return size;
    }

    public void func_196968_a(ListNBT list) {
        this.map.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.map.add(this.elementDeserializer.apply(list.func_150305_b(i)));
        }
    }

    public void toTag(ListNBT list) {
        for (int i = 0; i < this.getSize(); ++i) {
            list.add((Object)this.elementSerializer.apply(this.map.func_148745_a(i)));
        }
    }

    public int getSize() {
        return this.map.size();
    }
}

