/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntry;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntryQueue;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;

public class LithiumServerTickScheduler<T>
extends ServerTickList<T> {
    private static final Predicate<TickEntry<?>> PREDICATE_ANY_TICK = entry -> true;
    private static final Predicate<TickEntry<?>> PREDICATE_ACTIVE_TICKS = entry -> !entry.consumed;
    private final Long2ObjectSortedMap<TickEntryQueue<T>> scheduledTicksOrdered = new Long2ObjectAVLTreeMap();
    private final Map<NextTickListEntry<T>, TickEntry<T>> scheduledTicks = new HashMap<NextTickListEntry<T>, TickEntry<T>>();
    private final ArrayList<TickEntry<T>> executingTicks = new ArrayList();
    private final Predicate<T> invalidObjPredicate;
    private final ServerWorld world;
    private final Consumer<NextTickListEntry<T>> tickConsumer;

    public LithiumServerTickScheduler(ServerWorld world, Predicate<T> invalidPredicate, Function<T, ResourceLocation> idToName, Function<ResourceLocation, T> nameToId, Consumer<NextTickListEntry<T>> consumer) {
        super(world, invalidPredicate, idToName, nameToId, consumer);
        this.invalidObjPredicate = invalidPredicate;
        this.world = world;
        this.tickConsumer = consumer;
    }

    public void func_205365_a() {
        this.world.func_217381_Z().func_76320_a("cleaning");
        this.selectTicks(this.world.func_72863_F(), this.world.func_82737_E());
        this.world.func_217381_Z().func_219895_b("executing");
        this.executeTicks(this.tickConsumer);
        this.world.func_217381_Z().func_76319_b();
    }

    public boolean func_205361_b(BlockPos pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new NextTickListEntry(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.executing;
    }

    public boolean func_205359_a(BlockPos pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new NextTickListEntry(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.scheduled;
    }

    public void func_219497_a(Stream<NextTickListEntry<T>> stream) {
        stream.forEach(this::addScheduledTick);
    }

    public List<NextTickListEntry<T>> func_223188_a(ChunkPos chunkPos, boolean mutates, boolean getStaleTicks) {
        MutableBoundingBox box = new MutableBoundingBox(chunkPos.func_180334_c() - 2, chunkPos.func_180333_d() - 2, chunkPos.func_180332_e() + 2, chunkPos.func_180330_f() + 2);
        return this.func_205366_a(box, mutates, getStaleTicks);
    }

    public List<NextTickListEntry<T>> func_205366_a(MutableBoundingBox box, boolean remove, boolean getStaleTicks) {
        Predicate<TickEntry<?>> predicate = getStaleTicks ? PREDICATE_ANY_TICK : PREDICATE_ACTIVE_TICKS;
        return remove ? this.removeTicks(box, predicate) : this.collectTicks(box, predicate);
    }

    public void func_205368_a(MutableBoundingBox box, BlockPos pos) {
        List<NextTickListEntry<T>> list = this.func_205366_a(box, false, false);
        for (NextTickListEntry<T> tick : list) {
            this.addScheduledTick(new NextTickListEntry(tick.field_180282_a.func_177971_a((Vec3i)pos), tick.func_151351_a(), tick.field_77180_e, tick.field_82754_f));
        }
    }

    public void func_205362_a(BlockPos pos, T obj, int delay, TickPriority priority) {
        if (!this.invalidObjPredicate.test(obj)) {
            this.addScheduledTick(new NextTickListEntry(pos, obj, (long)delay + this.world.func_82737_E(), priority));
        }
    }

    public int func_225420_a() {
        int count = 0;
        for (TickEntry<T> entry : this.scheduledTicks.values()) {
            if (!entry.scheduled) continue;
            ++count;
        }
        return count;
    }

    public void selectTicks(ServerChunkProvider chunkManager, long time) {
        long headKey = LithiumServerTickScheduler.getBucketKey(time + 1L, TickPriority.EXTREMELY_HIGH) - 1L;
        int limit = 65565;
        boolean canTick = true;
        long prevChunk = Long.MIN_VALUE;
        ObjectIterator it = this.scheduledTicksOrdered.headMap(headKey).values().iterator();
        while (limit > 0 && it.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)it.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (!tick.scheduled) continue;
                if (limit > 0) {
                    long chunk = ChunkPos.func_77272_a((int)(tick.field_180282_a.func_177958_n() >> 4), (int)(tick.field_180282_a.func_177952_p() >> 4));
                    if (prevChunk != chunk) {
                        prevChunk = chunk;
                        canTick = chunkManager.func_222866_a(tick.field_180282_a);
                    }
                    if (canTick) {
                        tick.scheduled = false;
                        tick.executing = true;
                        this.executingTicks.add(tick);
                        --limit;
                        continue;
                    }
                }
                list.setTickAtIndex(w++, tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    public void executeTicks(Consumer<NextTickListEntry<T>> consumer) {
        for (TickEntry<T> entry : this.executingTicks) {
            try {
                entry.consumed = true;
                entry.executing = false;
                consumer.accept(entry);
                if (entry.scheduled) {
                    entry.consumed = false;
                    continue;
                }
                this.scheduledTicks.remove(entry);
            }
            catch (Throwable e) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)e, (String)"Exception while ticking");
                CrashReportCategory section = crash.func_85058_a("Block being ticked");
                CrashReportCategory.func_175750_a((CrashReportCategory)section, (BlockPos)entry.field_180282_a, null);
                throw new ReportedException(crash);
            }
        }
        this.executingTicks.clear();
    }

    private List<NextTickListEntry<T>> collectTicks(MutableBoundingBox box, Predicate<TickEntry<?>> predicate) {
        ArrayList<NextTickListEntry<T>> ret = new ArrayList<NextTickListEntry<T>>();
        for (TickEntryQueue ticks : this.scheduledTicksOrdered.values()) {
            for (int i = 0; i < ticks.size(); ++i) {
                TickEntry tick = ticks.getTickAtIndex(i);
                if (!box.func_175898_b((Vec3i)tick.field_180282_a) || !predicate.test(tick)) continue;
                ret.add(tick);
            }
        }
        return ret;
    }

    private List<NextTickListEntry<T>> removeTicks(MutableBoundingBox box, Predicate<TickEntry<?>> predicate) {
        ArrayList<NextTickListEntry<T>> ret = new ArrayList<NextTickListEntry<T>>();
        ObjectIterator timeIdxIt = this.scheduledTicksOrdered.values().iterator();
        while (timeIdxIt.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)timeIdxIt.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (!box.func_175898_b((Vec3i)tick.field_180282_a) || !predicate.test(tick)) {
                    list.setTickAtIndex(w++, tick);
                    continue;
                }
                tick.scheduled = false;
                ret.add(tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            timeIdxIt.remove();
        }
        return ret;
    }

    private void addScheduledTick(NextTickListEntry<T> tick) {
        TickEntry entry = this.scheduledTicks.computeIfAbsent(tick, TickEntry::new);
        if (!entry.scheduled) {
            TickEntryQueue timeIdx = (TickEntryQueue)this.scheduledTicksOrdered.computeIfAbsent(LithiumServerTickScheduler.getBucketKey(tick.field_77180_e, tick.field_82754_f), key -> new TickEntryQueue());
            timeIdx.push(entry);
            entry.scheduled = true;
        }
    }

    private static long getBucketKey(long time, TickPriority priority) {
        return time << 4 | (long)(priority.ordinal() & 0xF);
    }
}

