/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.fast_goal_selection;

import java.util.Set;
import me.jellysquid.mods.lithium.common.ai.ExtendedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.profiler.IProfiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GoalSelector.class})
public abstract class MixinGoalSelector {
    @Shadow
    @Final
    private IProfiler field_75781_c;
    @Mutable
    @Shadow
    @Final
    private Set<PrioritizedGoal> field_220892_d;
    private boolean[] disabledControlsArray;
    private PrioritizedGoal[] goalsByControlArray;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(IProfiler profiler, CallbackInfo ci) {
        this.disabledControlsArray = new boolean[4];
        this.goalsByControlArray = new PrioritizedGoal[4];
    }

    @Overwrite
    public void func_75774_a() {
        this.updateGoalStates();
        this.tickGoals();
    }

    private void updateGoalStates() {
        this.field_75781_c.func_76320_a("goalUpdate");
        this.stopGoals();
        this.cleanupControls();
        this.startGoals();
        this.field_75781_c.func_76319_b();
    }

    private void stopGoals() {
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (!goal.func_220773_g() || goal.func_75253_b() && !this.areControlsDisabled(goal)) continue;
            goal.func_75251_c();
        }
    }

    private void cleanupControls() {
        for (int i = 0; i < this.goalsByControlArray.length; ++i) {
            PrioritizedGoal goal = this.goalsByControlArray[i];
            if (goal == null || goal.func_220773_g()) continue;
            this.goalsByControlArray[i] = null;
        }
    }

    private void startGoals() {
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (goal.func_220773_g() || !goal.func_75250_a() || !this.areGoalControlsAvailable(goal)) continue;
            for (Goal.Flag control : MixinGoalSelector.getControls(goal)) {
                PrioritizedGoal otherGoal = this.getGoalOccupyingControl(control);
                if (otherGoal != null) {
                    otherGoal.func_75251_c();
                }
                this.setGoalOccupyingControl(control, goal);
            }
            goal.func_75249_e();
        }
    }

    private void tickGoals() {
        this.field_75781_c.func_76320_a("goalTick");
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (!goal.func_220773_g()) continue;
            goal.func_75246_d();
        }
        this.field_75781_c.func_76319_b();
    }

    private boolean areControlsDisabled(PrioritizedGoal goal) {
        for (Goal.Flag control : MixinGoalSelector.getControls(goal)) {
            if (!this.isControlDisabled(control)) continue;
            return true;
        }
        return false;
    }

    private boolean areGoalControlsAvailable(PrioritizedGoal goal) {
        for (Goal.Flag control : MixinGoalSelector.getControls(goal)) {
            if (this.isControlDisabled(control)) {
                return false;
            }
            PrioritizedGoal occupied = this.getGoalOccupyingControl(control);
            if (occupied == null || occupied.func_220771_a(goal)) continue;
            return false;
        }
        return true;
    }

    @Overwrite
    public void func_220880_a(Goal.Flag control) {
        this.disabledControlsArray[control.ordinal()] = true;
    }

    @Overwrite
    public void func_220886_b(Goal.Flag control) {
        this.disabledControlsArray[control.ordinal()] = false;
    }

    private boolean isControlDisabled(Goal.Flag control) {
        return this.disabledControlsArray[control.ordinal()];
    }

    private PrioritizedGoal getGoalOccupyingControl(Goal.Flag control) {
        return this.goalsByControlArray[control.ordinal()];
    }

    private void setGoalOccupyingControl(Goal.Flag control, PrioritizedGoal goal) {
        this.goalsByControlArray[control.ordinal()] = goal;
    }

    private static Goal.Flag[] getControls(PrioritizedGoal goal) {
        return ((ExtendedGoal)goal.func_220772_j()).getRequiredControls();
    }
}

