/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking;

import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerEngine;
import me.jellysquid.mods.lithium.common.entity.tracker.WorldWithEntityTrackerEngine;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public class MixinClientWorld {
    @Inject(method={"checkChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;addEntity(Lnet/minecraft/entity/Entity;)V", shift=At.Shift.BEFORE)})
    private void onEntityMoveAdd(Entity entity, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4;
        int y = MathHelper.func_76128_c((double)entity.func_226278_cu_()) >> 4;
        int z = MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4;
        EntityTrackerEngine tracker = WorldWithEntityTrackerEngine.getEntityTracker(this);
        tracker.onEntityAdded(x, y, z, (LivingEntity)entity);
    }

    @Inject(method={"checkChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;removeEntityAtIndex(Lnet/minecraft/entity/Entity;I)V", shift=At.Shift.BEFORE)})
    private void onEntityMoveRemove(Entity entity, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityTrackerEngine tracker = WorldWithEntityTrackerEngine.getEntityTracker(this);
        tracker.onEntityRemoved(entity.field_70176_ah, entity.field_70162_ai, entity.field_70164_aj, (LivingEntity)entity);
    }

    @Inject(method={"addEntityImpl"}, at={@At(value="FIELD", target="Lnet/minecraft/client/world/ClientWorld;entitiesById:Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;")})
    private void onEntityAdded(int id, Entity entity, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        int chunkX = MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4;
        int chunkY = MathHelper.func_76128_c((double)entity.func_226278_cu_()) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4;
        EntityTrackerEngine tracker = WorldWithEntityTrackerEngine.getEntityTracker(this);
        tracker.onEntityAdded(chunkX, chunkY, chunkZ, (LivingEntity)entity);
    }

    @Inject(method={"removeEntity"}, at={@At(value="HEAD")})
    private void onEntityRemoved(Entity entity, CallbackInfo ci) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        int chunkX = MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4;
        int chunkY = MathHelper.func_76128_c((double)entity.func_226278_cu_()) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4;
        EntityTrackerEngine tracker = WorldWithEntityTrackerEngine.getEntityTracker(this);
        tracker.onEntityRemoved(chunkX, chunkY, chunkZ, (LivingEntity)entity);
    }
}

