/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.chunk.fast_chunk_serialization;

import java.util.function.Function;
import me.jellysquid.mods.lithium.common.world.chunk.CompactingBitArray;
import me.jellysquid.mods.lithium.common.world.chunk.palette.LithiumPaletteHashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.PaletteArray;
import net.minecraft.util.palette.PaletteHashMap;
import net.minecraft.util.palette.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class MixinPalettedContainer<T> {
    @Shadow
    @Final
    private T field_205526_g;
    @Shadow
    @Final
    private ObjectIntIdentityMap<T> field_205523_d;
    @Shadow
    private int field_186024_e;
    @Shadow
    @Final
    private Function<CompoundNBT, T> field_205524_e;
    @Shadow
    @Final
    private Function<T, CompoundNBT> field_205525_f;
    @Shadow
    protected BitArray field_186021_b;
    @Shadow
    private IPalette<T> field_186022_c;

    @Shadow
    public abstract void func_210459_b();

    @Shadow
    public abstract void func_210460_c();

    @Shadow
    protected abstract T func_186015_a(int var1);

    @Inject(method={"writeChunkPalette"}, at={@At(value="HEAD")}, cancellable=true)
    public void write(CompoundNBT tag, String paletteKey, String dataKey, CallbackInfo ci) {
        if (this.field_186024_e > 8) {
            return;
        }
        this.func_210459_b();
        LithiumPaletteHashMap<T> compactedPalette = new LithiumPaletteHashMap<T>(this.field_205523_d, this.field_186024_e, null, this.field_205524_e, this.field_205525_f);
        compactedPalette.func_186041_a(this.field_205526_g);
        short[] remapped = ((CompactingBitArray)this.field_186021_b).compact(this.field_186022_c, compactedPalette, this.field_205526_g);
        int originalIntSize = this.field_186021_b.func_208535_c();
        int copyIntSize = Math.max(4, MathHelper.func_151241_e((int)compactedPalette.getSize()));
        if (this.field_186022_c instanceof LithiumPaletteHashMap && originalIntSize == copyIntSize) {
            long[] array = this.field_186021_b.func_188143_a();
            long[] copy = new long[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            ListNBT paletteTag = new ListNBT();
            ((LithiumPaletteHashMap)this.field_186022_c).toTag(paletteTag);
            tag.func_218657_a(paletteKey, (INBT)paletteTag);
            tag.func_197644_a(dataKey, copy);
        } else {
            BitArray copy = new BitArray(copyIntSize, 4096);
            for (int i = 0; i < remapped.length; ++i) {
                copy.func_188141_a(i, (int)remapped[i]);
            }
            ListNBT paletteTag = new ListNBT();
            compactedPalette.toTag(paletteTag);
            tag.func_218657_a(paletteKey, (INBT)paletteTag);
            tag.func_197644_a(dataKey, copy.func_188143_a());
        }
        this.func_210460_c();
        ci.cancel();
    }

    @Inject(method={"count"}, at={@At(value="HEAD")}, cancellable=true)
    public void count(PalettedContainer.ICountConsumer<T> consumer, CallbackInfo ci) {
        int size = MixinPalettedContainer.getPaletteSize(this.field_186022_c);
        if (size < 0) {
            return;
        }
        int[] counts = new int[size];
        this.field_186021_b.func_225421_a(i -> {
            int n = i;
            counts[n] = counts[n] + 1;
        });
        for (int i2 = 0; i2 < counts.length; ++i2) {
            consumer.accept(this.field_186022_c.func_186039_a(i2), counts[i2]);
        }
        ci.cancel();
    }

    private static int getPaletteSize(IPalette<?> palette) {
        if (palette instanceof PaletteHashMap) {
            return ((PaletteHashMap)palette).func_202136_b();
        }
        if (palette instanceof LithiumPaletteHashMap) {
            return ((LithiumPaletteHashMap)palette).getSize();
        }
        if (palette instanceof PaletteArray) {
            return ((PaletteArray)palette).func_202137_b();
        }
        return -1;
    }
}

