/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import xyz.pixelatedw.mineminenomi.api.abilities.PotionPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class PotionImmunitiesAbility
extends PotionPassiveAbility {
    public static final ImmunityInfo HEAT_RESISTANCES = ((ImmunityInfo)((ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addImmunityEffects(ModEffects.FROSTBITE, ModEffects.CANDY_STUCK, ModEffects.CANDLE_LOCK)).addResistanceEffect(ModEffects.FROZEN, 4)).addResistanceEffect(ModEffects.STICKY, 4)).addResistanceEffect(Effects.field_76436_u, 2);
    public static final PotionImmunitiesAbility HEAT_INSTANCE = new PotionImmunitiesAbility("Heat Immunities", HEAT_RESISTANCES);
    public static final PotionImmunitiesAbility LOGIA_HEAT_INSTANCE = new PotionImmunitiesAbility("Heat Logia Immunities", (ImmunityInfo)HEAT_RESISTANCES.addLogiaImmunities());
    public static final PotionImmunitiesAbility PERO_INSTANCE = new PotionImmunitiesAbility("Pero Immunities", (ImmunityInfo)new ImmunityInfo().addImmunityEffects(ModEffects.CANDY_STUCK));
    public static final PotionImmunitiesAbility LOGIA_INSTANCE = new PotionImmunitiesAbility("Logia Immunities", (ImmunityInfo)new ImmunityInfo().addLogiaImmunities());
    public static final PotionImmunitiesAbility YUKI_INSTANCE = new PotionImmunitiesAbility("Logia Immunities", (ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addLogiaImmunities()).addImmunityEffects(ModEffects.FROSTBITE));
    public static final PotionImmunitiesAbility MOKU_INSTANCE = new PotionImmunitiesAbility("Moku Immunities", (ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addLogiaImmunities()).addImmunityEffects(ModEffects.SMOKE));
    public static final PotionImmunitiesAbility GASU_INSTANCE = new PotionImmunitiesAbility("Gasu Immunities", (ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addImmunityEffects(Effects.field_76436_u)).addLogiaImmunities());
    public static final PotionImmunitiesAbility HIE_INSTANCE = new PotionImmunitiesAbility("Hie Immunities", (ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addImmunityEffects(ModEffects.FROZEN, ModEffects.FROSTBITE)).addLogiaImmunities());
    public static final PotionImmunitiesAbility BETA_INSTANCE = new PotionImmunitiesAbility("Beta Immunities", (ImmunityInfo)new ImmunityInfo().addImmunityEffects(ModEffects.STICKY, Effects.field_76431_k, Effects.field_76421_d));
    public static final PotionImmunitiesAbility GURA_INSTANCE = new PotionImmunitiesAbility("Gura Immunities", (ImmunityInfo)((ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addResistanceEffect(ModEffects.CANDLE_LOCK, 5)).addResistanceEffect(ModEffects.CANDY_STUCK, 5)).addResistanceEffect(ModEffects.FROZEN, 5));
    public static final PotionImmunitiesAbility YOMI_INSTANCE = new PotionImmunitiesAbility("Yomi Immunities", (ImmunityInfo)((ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addImmunityEffects(ModEffects.FROSTBITE, ModEffects.DIZZY, ModEffects.DRUNK, ModEffects.UNCONSCIOUS, Effects.field_76433_i, Effects.field_76428_l, Effects.field_76438_s, Effects.field_76436_u)).addResistanceEffect(ModEffects.FROZEN, 2)).addResistanceEffect(ModEffects.PARALYSIS, 2));
    private final ImmunityInfo immunityInfo;

    public PotionImmunitiesAbility(String name, ImmunityInfo info) {
        super(name, AbilityHelper.getDevilFruitCategory());
        this.checkPotionEvent = this::checkPotionEvent;
        this.immunityInfo = info;
    }

    private boolean checkPotionEvent(PlayerEntity player, EffectInstance effect) {
        if (AbilityHelper.isAffectedByWater((LivingEntity)player)) {
            return true;
        }
        ArrayList<Effect> immunityEffects = this.immunityInfo.getImmunityEffects();
        ArrayList<Effect> resistanceEffects = this.immunityInfo.getResistanceEffects();
        ArrayList<Integer> resistanceEffectsReduction = this.immunityInfo.getResistanceEffectsReduction();
        if (resistanceEffects.size() > 0) {
            for (int i = 0; i < resistanceEffects.size(); ++i) {
                if (!resistanceEffects.get(i).equals(effect.func_188419_a()) || effect.func_76458_c() >= 1) continue;
                int duration = effect.func_76459_b() / resistanceEffectsReduction.get(i);
                if (duration <= 20) {
                    return false;
                }
                ((EffectInstanceMixin)effect).setDuration(duration);
            }
        }
        return !immunityEffects.contains(effect.func_188419_a());
    }

    @Override
    public Ability create() {
        try {
            return (Ability)((Object)((Object)((Object)this)).getClass().getConstructor(String.class, ImmunityInfo.class).newInstance(this.getName(), this.immunityInfo));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static class ImmunityInfo {
        private ArrayList<Effect> immunityEffects = new ArrayList();
        private ArrayList<Effect> resistanceEffects = new ArrayList();
        private ArrayList<Integer> resistanceEffectsReduction = new ArrayList();

        public ArrayList<Effect> getImmunityEffects() {
            return this.immunityEffects;
        }

        public ArrayList<Effect> getResistanceEffects() {
            return this.resistanceEffects;
        }

        public ArrayList<Integer> getResistanceEffectsReduction() {
            return this.resistanceEffectsReduction;
        }

        public <T extends ImmunityInfo> T addImmunityEffects(Effect ... immunityEffects) {
            this.immunityEffects.addAll(Arrays.asList(immunityEffects));
            return (T)this;
        }

        public <T extends ImmunityInfo> T addResistanceEffect(Effect resistanceEffect, Integer reduction) {
            this.resistanceEffects.add(resistanceEffect);
            this.resistanceEffectsReduction.add(reduction);
            return (T)this;
        }

        public <T extends ImmunityInfo> T addLogiaImmunities() {
            this.addResistanceEffect(ModEffects.MOVEMENT_BLOCKED, 2);
            return (T)this;
        }
    }
}

