/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.HeatBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.artofweather.ChargedWeatherBallParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class HeatBallAbility
extends Ability {
    public static final HeatBallAbility INSTANCE = new HeatBallAbility();
    private static final ParticleEffect CHARGE_PARTICLES = new ChargedWeatherBallParticleEffect(WyHelper.hexToRGB("#FF0000"), ModParticleTypes.GASU);

    public HeatBallAbility() {
        super("Heat Ball", AbilityHelper.getStyleCategory());
        this.setDescription("Launch a Heat Ball from your Clima Tact to use for different Tempos\n\n\u00a72SHIFT-USE\u00a7r: Loads the ball into the clima tact");
        this.setMaxCooldown(1.0);
        this.setInPool(AbilityPool.WEATHER_BALLS);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!ItemsHelper.isClimaTact(player.func_184614_ca())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_CLIMA_TACT, new Object[0]));
            return false;
        }
        ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
        player.func_184614_ca().func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        if (player.func_225608_bj_()) {
            climaTact.chargeWeatherBall(player.func_184614_ca(), "H");
            ArtOfWeatherHelper.checkForTempo(player, CHARGE_PARTICLES);
        } else {
            HeatBallProjectile proj = new HeatBallProjectile(player.field_70170_p, (LivingEntity)player);
            proj.func_70012_b(trace.func_216347_e().func_82615_a(), player.func_226278_cu_() + (double)player.func_70047_e() - 0.5, trace.func_216347_e().func_82616_c(), player.field_70177_z, player.field_70125_A);
            proj.func_213293_j(0.0, 0.3, 0.0);
            player.field_70170_p.func_217376_c((Entity)proj);
        }
        return true;
    }
}

