/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherEggProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class WeatherEggAbility
extends Ability {
    public static final WeatherEggAbility INSTANCE = new WeatherEggAbility();

    public WeatherEggAbility() {
        super("Weather Egg", AbilityHelper.getStyleCategory());
        this.setDescription("Instantly creates a Weather Cloud as if combining a Cool Ball and a Heat Ball");
        this.setMaxCooldown(16.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!ItemsHelper.isClimaTact(player.func_184614_ca())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_CLIMA_TACT, new Object[0]));
            return false;
        }
        ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
        if (climaTact.getLevel() < 3) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SORCERY_CLIMA_TACT, new Object[0]));
            return false;
        }
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
        WeatherEggProjectile proj = new WeatherEggProjectile(player.field_70170_p, (LivingEntity)player);
        proj.func_70012_b(trace.func_216347_e().func_82615_a(), player.func_226278_cu_() + (double)player.func_70047_e() - 0.5, trace.func_216347_e().func_82616_c(), player.field_70177_z, player.field_70125_A);
        proj.func_213293_j(0.0, 0.3, 0.0);
        player.field_70170_p.func_217376_c((Entity)proj);
        return true;
    }
}

