/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class SuplexAbility
extends ChargeableAbility {
    public static final SuplexAbility INSTANCE = new SuplexAbility();
    private LivingEntity grabbedEntity = null;

    public SuplexAbility() {
        super("Suplex", AbilityHelper.getStyleCategory());
        this.setDescription("Grabs an opponent from the back and launches it into the ground");
        this.setMaxCooldown(15.0);
        this.setMaxChargeTime(2.0);
        this.onStartChargingEvent = this::onUseEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        List list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, 1.2, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        list.removeIf(entity -> AbilityHelper.isTargetBlockingAbility(player, entity));
        if (!HakiHelper.hasHardeningActive((LivingEntity)player)) {
            list.removeIf(entity -> DevilFruitCapability.get(entity).isLogia());
        }
        this.grabbedEntity = list.size() > 0 ? (LivingEntity)list.get(0) : null;
        return list.size() > 0;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        if (!this.grabbedEntity.func_70089_S() || DevilFruitCapability.get(this.grabbedEntity).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, this.grabbedEntity)) {
            this.stopCharging(player);
        }
        this.grabbedEntity.field_70125_A = this.grabbedEntity.field_70127_C;
        this.grabbedEntity.field_70177_z = this.grabbedEntity.field_70126_B;
        this.grabbedEntity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        float distance = 1.0f;
        Vec3d lookVec = this.grabbedEntity.func_70040_Z();
        Vec3d pos = new Vec3d(this.grabbedEntity.func_226277_ct_() - lookVec.field_72450_a * (double)distance, this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_() - lookVec.field_72449_c * (double)distance);
        player.func_70634_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.grabbedEntity == null || this.getChargeTime() >= this.getMaxChargeTime()) {
            return false;
        }
        this.grabbedEntity.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 6.0f);
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), 1.0f);
        explosion.setStaticDamage(6.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(1));
        explosion.setDamageEntities(true);
        explosion.func_199592_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this));
        explosion.doExplosion();
        return true;
    }
}

