/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.VenomDemonZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class DokuFuguAbility
extends ContinuousAbility
implements IParallelContinuousAbility,
IBodyOverlayAbility {
    public static final DokuFuguAbility INSTANCE = new DokuFuguAbility();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.DOKU_COATING).setColor(new Color(1.0f, 1.0f, 1.0f, 0.6f));

    public DokuFuguAbility() {
        super("Doku Fugu", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setThreshold(60.0);
        this.setDescription("The user covers themselves in poison creating a thin protective layer to damage");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        return !VenomDemonZoanInfo.INSTANCE.isActive((LivingEntity)player);
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        player.func_195064_c(new EffectInstance(ModEffects.DOKU_GUARD, 2, 2, false, false));
        if (VenomDemonZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            this.stopContinuity(player);
        }
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }

    public void enableVenomDemoMode() {
        this.setCustomTexture("doku_fugu_venom");
    }

    public void disableVenomDemoMode() {
        this.setCustomTexture("");
    }
}

