/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningBallEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.electro.ElectroChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class ElectricalShowerAbility
extends ChargeableAbility
implements IFallDamageBlockingAbility {
    public static final ElectricalShowerAbility INSTANCE = new ElectricalShowerAbility();
    private int boltsLeft = 10;
    private static final ElectroChargingParticleEffect PARTICLES = new ElectroChargingParticleEffect();
    private LightningBallEntity ballEntity = null;
    private static final int COOLDOWN = 22;
    private static final int CHARGE_TIME = 8;

    public ElectricalShowerAbility() {
        super("Electrical Shower", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(22.0);
        this.setMaxChargeTime(8.0);
        this.setInPool(AbilityPool.MINK_ELECTRO);
        this.setDescription("Launches the user into the air and showers down lightning bolts underneath");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        this.boltsLeft = (int)WyHelper.randomWithRange(8, 10);
        if (!eleclawEnabled) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_ELECLAW, new Object[0]));
            return false;
        }
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        this.setMaxChargeTime(sulongEnabled ? 5.333333492279053 : 8.0);
        this.setMaxCooldown(sulongEnabled ? 11.0 : 22.0);
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        if (i % 5 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 4, 1, false, false));
        float percentage = 1.0f - (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        if (this.ballEntity == null) {
            LightningBallEntity ball = new LightningBallEntity((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
            player.field_70170_p.func_217376_c((Entity)ball);
            this.ballEntity = ball;
        } else {
            float distance = percentage * 2.0f;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * (double)distance, player.func_226278_cu_() + (double)player.func_70047_e() * 0.85 + lookVec.field_72448_b * (double)distance, player.func_226281_cx_() + lookVec.field_72449_c * (double)distance);
            this.ballEntity.setSize(percentage * 0.3f);
            this.ballEntity.setLightningLength(3.0f);
            this.ballEntity.func_70080_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), player.field_70177_z, player.field_70125_A);
        }
        if ((double)percentage > 0.65) {
            Vec3d startVec = player.func_213303_ch();
            boolean blockUnder = player.field_70170_p.func_217299_a(new RayTraceContext(startVec, startVec.func_72441_c(0.0, -15.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK);
            if (blockUnder) {
                player.func_213293_j(player.func_213322_ci().field_72450_a, 1.0, player.func_213322_ci().field_72449_c);
                player.field_70133_I = true;
            } else {
                AbilityHelper.slowEntityFall((LivingEntity)player);
            }
            if ((double)percentage > 0.9 && player.field_70173_aa % 2 == 0 && this.boltsLeft > 0) {
                boolean canShoot;
                boolean bl = canShoot = !player.field_70170_p.func_217299_a(new RayTraceContext(startVec, startVec.func_72441_c(0.0, -8.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK);
                if (canShoot) {
                    BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)player, 48.0);
                    double beamDistance = Math.sqrt(player.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
                    ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
                    EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
                    for (int z = 0; z < 3 && this.boltsLeft - 1 > 0; ++z) {
                        --this.boltsLeft;
                        LightningEntity bolt = new LightningEntity((Entity)player, player.func_226277_ct_() + WyHelper.randomWithRange(-3, 3), player.func_226278_cu_(), player.func_226281_cx_() + WyHelper.randomWithRange(-3, 3), player.field_70177_z, player.field_70125_A, (int)beamDistance + 2, 8.0f);
                        bolt.setAliveTicks(10);
                        bolt.setDamage(3.0f + Math.min(eleclawAbility.getElectricPower(player) / 2.0f, 6.0f));
                        bolt.setExplosion(2, false, 0.0f);
                        bolt.setSize(0.025f);
                        bolt.setBoxSizeDivision(0.025);
                        bolt.disableExplosionKnockback();
                        bolt.setSegments((int)(beamDistance + WyHelper.randomWithRange(-4, 8)));
                        player.field_70170_p.func_217376_c((Entity)bolt);
                    }
                }
            }
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        Vec3d startVec;
        boolean canShoot;
        if (this.ballEntity != null) {
            this.ballEntity.func_70106_y();
            this.ballEntity = null;
        }
        boolean bl = canShoot = !player.field_70170_p.func_217299_a(new RayTraceContext(startVec = player.func_213303_ch(), startVec.func_72441_c(0.0, -10.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK);
        if (!canShoot) {
            return true;
        }
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        if (eleclawAbility != null && eleclawAbility.isContinuous()) {
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)player, 50.0);
            double beamDistance = Math.sqrt(player.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            for (int z = 0; z < this.boltsLeft; ++z) {
                LightningEntity bolt = new LightningEntity((Entity)player, player.func_226277_ct_() + WyHelper.randomWithRange(-3, 3), player.func_226278_cu_(), player.func_226281_cx_() + WyHelper.randomWithRange(-3, 3), player.field_70177_z, player.field_70125_A, (int)beamDistance + 2, 8.0f);
                bolt.setAliveTicks(5);
                bolt.setDamage(2.0f + Math.min(eleclawAbility.getElectricPower(player) / 2.0f, 6.0f));
                bolt.setExplosion(2, false, 0.0f);
                bolt.setSize(0.025f);
                bolt.disableLightningMimic();
                bolt.setBoxSizeDivision(0.025);
                bolt.disableExplosionKnockback();
                bolt.setSegments((int)(beamDistance + WyHelper.randomWithRange(-4, 8)));
                player.field_70170_p.func_217376_c((Entity)bolt);
            }
            player.func_71020_j(2.0f);
            eleclawAbility.reduceUsage(player, 2);
        }
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
    }

    @Override
    public boolean hasFallDamage() {
        boolean a = this.getState().equals((Object)Ability.State.COOLDOWN);
        return !a;
    }
}

